/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adx.common.ip;

import com.bxm.adx.common.ip.IpService;
import com.bxm.warcar.ip.IP;
import com.bxm.warcar.ip.IpLibrary;
import com.bxm.warcar.ip.IpResultSet;
import com.bxm.warcar.ip.MatchedIpLibrary;
import com.bxm.warcar.utils.JsonHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
public class DefaultIpServiceImpl
implements IpService {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultIpServiceImpl.class);
    @Autowired
    @Qualifier(value="ipIpNetIpLibrary")
    private IpLibrary ipLibrary;
    @Autowired
    private MatchedIpLibrary matchedIpLibrary;

    private IP analyze2(String ip) {
        IP ipip = null;
        try {
            IpResultSet resultSet;
            ip = DefaultIpServiceImpl.fixedIp(ip);
            ipip = this.getIpByIpLibrary(ip);
            if (ipip == null) {
                ipip = this.getDefault(ip);
            }
            if ((resultSet = this.matchedIpLibrary.find(ip)) != null) {
                ipip.setStrictRegioncode(resultSet.get().getRegioncode());
            }
        }
        catch (Exception e) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error("getIp: ", (Throwable)e);
            }
            ipip = this.getDefault(ip);
        }
        return ipip;
    }

    @Override
    public IP analyze(String ip) {
        try {
            IP ipip = this.analyze2(ip);
            if (ipip != null) {
                return ipip;
            }
            IpResultSet resultSet = this.matchedIpLibrary.find(ip = DefaultIpServiceImpl.fixedIp(ip));
            if (null == resultSet) {
                return this.getIpByIpLibrary(ip);
            }
            if (!resultSet.isMatched()) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("IP\u5e93\u96c6\u5339\u914d\u5931\u8d25\uff01{}", (Object)JsonHelper.convert((Object)resultSet));
                }
                return this.getDefault(ip);
            }
            IP rs = resultSet.get();
            return null == rs ? this.getDefault(ip) : rs;
        }
        catch (Exception e) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error("getIp: ", (Throwable)e);
            }
            return this.getDefault(ip);
        }
    }

    private IP getIpByIpLibrary(String ip) {
        IP iprst = this.ipLibrary.find(ip);
        if (null == iprst) {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("\u65e0\u6cd5\u83b7\u53d6\u5230IP\uff1a{} \u7684\u533a\u57df\u4fe1\u606f", (Object)ip);
            }
            iprst = this.getDefault(ip);
        }
        return iprst;
    }

    private IP getDefault(String ip) {
        return new IP("\u4e2d\u56fd", "\u4e2d\u56fd", "\u4e2d\u56fd");
    }

    private static String fixedIp(String ip) {
        if (DefaultIpServiceImpl.isIPv4(ip)) {
            return ip;
        }
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Invalid ip: {}", (Object)ip);
        }
        return "127.0.0.1";
    }

    private static boolean isIPv4(String ip) {
        return ip.matches("((25[0-5]|2[0-4]\\d|((1\\d{2})|([1-9]?\\d)))\\.){3}(25[0-5]|2[0-4]\\d|((1\\d{2})|([1-9]?\\d)))");
    }
}

