/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adx.common.market;

import com.bxm.adx.common.market.Deal;
import com.bxm.adx.common.market.DealWrapper;
import com.bxm.adx.common.market.Market;
import com.bxm.adx.common.market.MarketOrders;
import com.bxm.adx.common.market.exchange.PriorityExchanger;
import com.bxm.adx.common.market.filter.Filter;
import com.bxm.adx.common.revealbottom.RevealBottom;
import com.bxm.adx.common.sell.BidResponse;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;

@Primary
@Configuration
public class DefaultMarketImpl
implements Market {
    private static final Logger log = LoggerFactory.getLogger(DefaultMarketImpl.class);
    private final PriorityExchanger priorityExchanger;
    private final Filter filter;
    private final RevealBottom revealBottom;

    public DefaultMarketImpl(PriorityExchanger priorityExchanger, Filter filter, RevealBottom revealBottom) {
        this.priorityExchanger = priorityExchanger;
        this.filter = filter;
        this.revealBottom = revealBottom;
    }

    @Override
    public BidResponse exchange(MarketOrders orders) {
        if (CollectionUtils.isEmpty(orders.getPositions())) {
            if (log.isDebugEnabled()) {
                log.debug("positions is null {} ", orders.getBidRequest().getImps());
            }
            return null;
        }
        List<Deal> deals = this.priorityExchanger.exchange(orders);
        if (CollectionUtils.isNotEmpty(deals)) {
            this.filter.filter(deals);
        } else {
            deals = this.revealBottom.exchange(orders);
            if (CollectionUtils.isEmpty(deals)) {
                return null;
            }
        }
        return DealWrapper.merge(deals);
    }
}

