/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adx.common.market.filter;

import com.bxm.adx.common.market.Deal;
import com.bxm.adx.common.market.filter.Filter;
import com.bxm.adx.common.sell.BidResponse;
import com.bxm.adx.common.sell.response.Bid;
import com.bxm.adx.common.sell.response.SeatBid;
import com.bxm.adx.common.utils.MapHelper;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;

@Order(value=0x7FFFFFFF)
@Configuration
public class PriceLowerFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(PriceLowerFilter.class);

    @Override
    public void filter(List<Deal> deals) {
        HashMap higher = Maps.newHashMap();
        deals.removeIf(deal -> {
            BidResponse response = deal.getBidResponse();
            if (null == response) {
                return true;
            }
            List<SeatBid> seatBid = response.getSeat_bid();
            if (CollectionUtils.isEmpty(seatBid)) {
                return true;
            }
            seatBid.removeIf(bid -> {
                List<Bid> bidList = bid.getBid();
                if (CollectionUtils.isEmpty(bidList)) {
                    return true;
                }
                bidList.removeIf(b -> {
                    String imp_id = b.getImp_id();
                    Float price = b.getPrice();
                    if (null == price) {
                        return true;
                    }
                    Float max = MapHelper.get(higher, imp_id, price);
                    if (price.compareTo(max) > 0) {
                        higher.put(imp_id, price);
                        return true;
                    }
                    return false;
                });
                return CollectionUtils.isEmpty(bidList);
            });
            return CollectionUtils.isEmpty(seatBid);
        });
    }

    public static void main(String[] args) {
        System.out.println(Float.compare(0.0f, 0.0f));
        System.out.println(Float.compare(1.0f, 0.0f));
        System.out.println(Float.compare(0.0f, 1.0f));
    }
}

