/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adx.common.sdkconfig;

import com.bxm.adx.common.AdxErrEnum;
import com.bxm.adx.common.AdxException;
import com.bxm.adx.common.PositionSdkConfigChannelEnum;
import com.bxm.adx.common.ingetration.UserServiceIntegration;
import com.bxm.adx.common.sdkconfig.SdkConfig;
import com.bxm.adx.common.sdkconfig.SdkConfigDao;
import com.bxm.adx.common.sdkconfig.SdkConfigService;
import com.bxm.adx.common.sell.position.Position;
import com.bxm.adx.common.sell.position.PositionService;
import com.bxm.adx.facade.constant.enums.DevOsEnum;
import com.bxm.adx.facade.constant.enums.SdkVersionEnum;
import com.bxm.adx.facade.model.position.SdkConfigRequest;
import com.bxm.adx.facade.model.position.SdkConfigResponse;
import com.bxm.user.facade.DevRequest;
import com.bxm.user.facade.UserProfile;
import com.bxm.warcar.utils.DateHelper;
import com.bxm.warcar.utils.StringHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.context.annotation.Configuration;

@Configuration
public class SdkConfigServiceImpl
implements SdkConfigService {
    private static final Logger log = LoggerFactory.getLogger(SdkConfigServiceImpl.class);
    private final SdkConfigDao sdkConfigDao;
    private final PositionService positionService;
    private final UserServiceIntegration userService;

    public SdkConfigServiceImpl(SdkConfigDao sdkConfigDao, PositionService positionService, UserServiceIntegration userService) {
        this.sdkConfigDao = sdkConfigDao;
        this.positionService = positionService;
        this.userService = userService;
    }

    @Override
    public List<SdkConfigResponse> getByPositionId(SdkConfigRequest sdkConfigRequest) {
        boolean result;
        boolean isSupportException = StringUtils.isNotBlank((CharSequence)sdkConfigRequest.getSdkv()) && StringHelper.isNewVersion((String)SdkVersionEnum.SUPPORT_EXCEPTION_325.getVersion(), (String)sdkConfigRequest.getSdkv());
        String positionId = sdkConfigRequest.getPositionId();
        Position position = this.positionService.getByPositionId(positionId);
        if (null == position) {
            if (log.isDebugEnabled()) {
                log.debug("\u5e7f\u544a\u4f4dSDK\u914d\u7f6e\u4e2d\uff0c\u6ca1\u6709\u83b7\u53d6\u5230\uff1a{} \u7684\u5e7f\u544a\u4f4d\u4fe1\u606f\u3002", (Object)positionId);
            }
            if (isSupportException) {
                throw new AdxException(AdxErrEnum.APP_INFO_ERR);
            }
            return Collections.emptyList();
        }
        if (!position.getPositionScene().equals(sdkConfigRequest.getPositionScene())) {
            if (isSupportException) {
                throw new AdxException(AdxErrEnum.APP_INFO_ERR);
            }
            return Collections.emptyList();
        }
        if (isSupportException && !(result = this.positionService.verifyPosition(position, sdkConfigRequest.getAppId(), sdkConfigRequest.getPackageName(), sdkConfigRequest.getSdkv()))) {
            throw new AdxException(AdxErrEnum.APP_INFO_ERR);
        }
        List<SdkConfig> sdkConfigs = this.sdkConfigDao.getByPositionId(positionId);
        sdkConfigs = Boolean.TRUE.equals(sdkConfigRequest.getIsDebug()) ? this.getSdkConfigsForDebug(sdkConfigs) : this.getSdkConfigForDynamic(sdkConfigs, sdkConfigRequest);
        ArrayList<SdkConfigResponse> sdkConfigResponses = new ArrayList<SdkConfigResponse>(sdkConfigs.size());
        for (SdkConfig sdkConfig : sdkConfigs) {
            SdkConfigResponse sdkConfigResponse = new SdkConfigResponse();
            BeanUtils.copyProperties((Object)sdkConfig, (Object)sdkConfigResponse);
            sdkConfigResponses.add(sdkConfigResponse);
        }
        return sdkConfigResponses;
    }

    private List<SdkConfig> getSdkConfigForDynamic(List<SdkConfig> sdkConfigs, SdkConfigRequest sdkConfigRequest) {
        boolean isSupportBxmBackup;
        UserProfile user = this.userService.getUser(DevRequest.builder().os(sdkConfigRequest.getOs()).imei(sdkConfigRequest.getImei()).imeiMd5(sdkConfigRequest.getImei_md5()).anid(sdkConfigRequest.getAnid()).anidMd5(sdkConfigRequest.getAnid_md5()).oaid(sdkConfigRequest.getOaid()).idfa(sdkConfigRequest.getIdfa()).idfaMd5(sdkConfigRequest.getIdfa_md5()).build());
        if (null == user || StringUtils.isBlank((CharSequence)user.getUid())) {
            return sdkConfigs;
        }
        String devNo = user.getUid();
        SdkConfig bxmSdkConfig = null;
        SdkConfig bxmBackupSdkConfig = null;
        SdkConfig bdSdkConfig = null;
        SdkConfig ksSdkConfig = null;
        SdkConfig adSdkConfig = null;
        boolean isIos = Objects.equals(sdkConfigRequest.getOs(), DevOsEnum.IOS.getId());
        boolean isSupportBdAndKsAndAd = StringUtils.isNotBlank((CharSequence)sdkConfigRequest.getSdkv()) && StringHelper.isNewVersion((String)SdkVersionEnum.IOS_SUPPORT_BD_AND_KS_331.getVersion(), (String)sdkConfigRequest.getSdkv());
        for (SdkConfig conf : sdkConfigs) {
            if (Objects.equals(PositionSdkConfigChannelEnum.BXM.getCode(), conf.getChannelType())) {
                bxmSdkConfig = conf;
            }
            if (Objects.equals(PositionSdkConfigChannelEnum.BACKUP.getCode(), conf.getChannelType())) {
                bxmBackupSdkConfig = conf;
            }
            if (!isIos || isSupportBdAndKsAndAd) continue;
            if (Objects.equals(PositionSdkConfigChannelEnum.BD.getCode(), conf.getChannelType())) {
                bdSdkConfig = conf;
                continue;
            }
            if (Objects.equals(PositionSdkConfigChannelEnum.KS.getCode(), conf.getChannelType())) {
                ksSdkConfig = conf;
                continue;
            }
            if (!Objects.equals(PositionSdkConfigChannelEnum.AD.getCode(), conf.getChannelType())) continue;
            adSdkConfig = conf;
        }
        if (bxmBackupSdkConfig != null) {
            sdkConfigs.remove(bxmBackupSdkConfig);
        }
        if (bdSdkConfig != null) {
            sdkConfigs.remove(bdSdkConfig);
        }
        if (ksSdkConfig != null) {
            sdkConfigs.remove(ksSdkConfig);
        }
        if (adSdkConfig != null) {
            sdkConfigs.remove(adSdkConfig);
        }
        if (bxmSdkConfig != null && bxmSdkConfig.getRateOfFlow() != null && sdkConfigs.size() > 1 && bxmSdkConfig.getSort() != 1) {
            boolean isTopBxm;
            HashMap<String, Integer> testDevMap = new HashMap<String, Integer>();
            testDevMap.put("F472E98E-32BE-46AD-AB49-78C0C6FA1868", bxmSdkConfig.getRateOfFlow());
            testDevMap.put("FD4AA4C3-8859-4CB4-A9B5-37424FFB4EFC", 100);
            testDevMap.put("867648032168948", bxmSdkConfig.getRateOfFlow());
            testDevMap.put("868133036330918", 100);
            boolean bl = isTopBxm = Math.abs(devNo.hashCode() % 100) < testDevMap.getOrDefault(devNo, bxmSdkConfig.getRateOfFlow());
            if (isTopBxm) {
                sdkConfigs.remove(bxmSdkConfig);
                bxmSdkConfig.setSort(1);
                sdkConfigs.add(0, bxmSdkConfig);
                for (int i = 0; i < sdkConfigs.size(); ++i) {
                    if (i <= 0) continue;
                    SdkConfig nextSdkConfig = sdkConfigs.get(i);
                    nextSdkConfig.setSort(nextSdkConfig.getSort() + 1);
                }
            }
        }
        String dmy = DateHelper.format((Date)new Date(), (String)"yyyyMMdd");
        Map<String, Integer> channelTypeAndViewNumMap = this.sdkConfigDao.getByPositionIdDateChannelViewData(sdkConfigRequest.getPositionId(), dmy, devNo);
        if (channelTypeAndViewNumMap != null && channelTypeAndViewNumMap.size() > 0) {
            int loopCount = 0;
            for (SdkConfig config : sdkConfigs) {
                Integer viewNum = channelTypeAndViewNumMap.get(PositionSdkConfigChannelEnum.get(config.getChannelType()).getDateChannelView());
                if (viewNum == null || config.getFrequency() == null || viewNum < config.getFrequency()) continue;
                SdkConfig lastSdkConfig = sdkConfigs.get(sdkConfigs.size() - 1);
                config.setSort(lastSdkConfig.getSort() + 1);
                ++loopCount;
            }
            if (loopCount >= sdkConfigs.size()) {
                this.sdkConfigDao.deletePositionIdDateChannelViewData(sdkConfigRequest.getPositionId(), dmy, devNo);
            }
        }
        boolean bl = isSupportBxmBackup = StringUtils.isNotBlank((CharSequence)sdkConfigRequest.getSdkv()) && StringHelper.isNewVersion((String)SdkVersionEnum.SUPPORT_BXM_BACKUP_30.getVersion(), (String)sdkConfigRequest.getSdkv());
        if (isSupportBxmBackup && bxmBackupSdkConfig != null) {
            sdkConfigs.add(bxmBackupSdkConfig);
        }
        return sdkConfigs;
    }

    private List<SdkConfig> getSdkConfigsForDebug(List<SdkConfig> sdkConfigs) {
        if (CollectionUtils.isEmpty(sdkConfigs)) {
            return Collections.emptyList();
        }
        ArrayList<SdkConfig> resps = new ArrayList<SdkConfig>();
        for (SdkConfig conf : sdkConfigs) {
            if (!Objects.equals(PositionSdkConfigChannelEnum.BXM.getCode(), conf.getChannelType())) continue;
            resps.add(conf);
            return resps;
        }
        return resps;
    }
}

