/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adx.common.sell.creatives;

import com.alibaba.fastjson.JSON;
import com.bxm.abtest.facade.enums.AlgorithmNameEnum;
import com.bxm.abtest.facade.enums.SeconeEnum;
import com.bxm.abtest.facade.model.AlgorithmRequest;
import com.bxm.adx.common.ingetration.AbtestServiceIntegration;
import com.bxm.adx.common.sell.creatives.AssetsCounter;
import com.bxm.adx.common.sell.creatives.AssetsFlowConfig;
import com.bxm.adx.common.sell.creatives.AssetsRequest;
import com.bxm.adx.common.sell.creatives.AssetsSort;
import com.bxm.adx.common.sell.creatives.MediaEntranceCreativesBuider;
import com.bxm.adx.common.sell.creatives.MediaEntranceCreativesService;
import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.cache.impls.redis.JedisFetcher;
import com.bxm.warcar.utils.NamedThreadFactory;
import com.bxm.warcar.utils.TypeHelper;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.RandomUtils;
import org.apache.commons.math3.distribution.BetaDistribution;
import org.apache.curator.shaded.com.google.common.collect.Maps;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MediaEntranceCreativesServiceImpl
implements MediaEntranceCreativesService {
    private static final Logger log = LoggerFactory.getLogger(MediaEntranceCreativesServiceImpl.class);
    private ExecutorService pool = new ThreadPoolExecutor(200, 400, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)new NamedThreadFactory("assets"));
    @Autowired
    private JedisFetcher fetcher;
    @Autowired
    AbtestServiceIntegration abtestServiceIntegration;

    @Override
    public String best(String positionId, String uid) {
        String result;
        Boolean checkPosition = this.checkPosition(positionId);
        AssetsFlowConfig assetsFlowConfig = this.getAssetsFlowConfig();
        if (assetsFlowConfig != null && checkPosition.booleanValue() && MediaEntranceCreativesServiceImpl.threeCondition(uid, assetsFlowConfig) && StringUtils.isNotBlank((String)(result = this.newBest(positionId, uid, assetsFlowConfig)))) {
            return result;
        }
        String flowRates = (String)this.fetcher.fetchWithSelector(MediaEntranceCreativesBuider.flowRate(positionId), String.class, 2);
        if (StringUtils.isBlank((String)flowRates)) {
            return null;
        }
        Map result2 = (Map)JSON.parseObject((String)flowRates, Map.class);
        HashMap reateMap = Maps.newHashMap();
        if (MapUtils.isNotEmpty((Map)result2)) {
            result2.forEach((key, value) -> reateMap.put(key, TypeHelper.castToDouble((Object)value)));
        }
        return this.get(reateMap);
    }

    @Override
    public String abTestBest(AssetsRequest assetsRequest) {
        AlgorithmRequest algorithmRequest = new AlgorithmRequest();
        algorithmRequest.setPositionId(assetsRequest.getPositionId());
        algorithmRequest.setRequestId(assetsRequest.getBidid());
        algorithmRequest.setSceneCode(SeconeEnum.SECONE_ONE.getSeconeCode());
        algorithmRequest.setUserId(assetsRequest.getUid());
        String algorithmCode = this.abtestServiceIntegration.getAlgorithmCode(algorithmRequest);
        if (StringUtils.equalsIgnoreCase((String)algorithmCode, (String)AlgorithmNameEnum.ALGORITHM_SDK_ASSETS_ONE.getAlgorithmCode())) {
            return this.A1Best(assetsRequest);
        }
        String flowRates = (String)this.fetcher.fetchWithSelector(MediaEntranceCreativesBuider.flowRate(assetsRequest.getPositionId()), String.class, 2);
        if (StringUtils.isBlank((String)flowRates)) {
            return null;
        }
        Map result = (Map)JSON.parseObject((String)flowRates, Map.class);
        HashMap reateMap = Maps.newHashMap();
        if (MapUtils.isNotEmpty((Map)result)) {
            result.forEach((key, value) -> reateMap.put(key, TypeHelper.castToDouble((Object)value)));
        }
        return this.get(reateMap);
    }

    private String A1Best(AssetsRequest assetsRequest) {
        List<String> allAssets = assetsRequest.getAssetIdsList();
        if (CollectionUtils.isEmpty(allAssets)) {
            return null;
        }
        if (allAssets.size() == 1) {
            return allAssets.get(0);
        }
        ArrayList<AssetsSort> assetsSortList = new ArrayList<AssetsSort>();
        ArrayList futures = Lists.newArrayList();
        for (String assetsId : allAssets) {
            Future<AssetsSort> future = this.pool.submit(() -> {
                AssetsSort assetsSort = new AssetsSort();
                assetsSort.setAssetId(assetsId);
                assetsSort.setCtr(this.ctr(assetsRequest.getPositionId(), assetsId));
                return assetsSort;
            });
            futures.add(future);
        }
        for (Future future : futures) {
            try {
                AssetsSort assetsSort = (AssetsSort)future.get();
                assetsSortList.add(assetsSort);
            }
            catch (InterruptedException | ExecutionException e) {
                if (!log.isErrorEnabled()) continue;
                log.error("get: {}", (Throwable)e);
            }
        }
        Collections.sort(assetsSortList);
        return ((AssetsSort)assetsSortList.get(0)).getAssetId();
    }

    private String newBest(String positionId, String uid, AssetsFlowConfig assetsFlowConfig) {
        List allAssets = this.fetcher.hfetchListWithSelector(MediaEntranceCreativesBuider.positionAllCreatives(), positionId, String.class, 2);
        if (CollectionUtils.isEmpty((Collection)allAssets)) {
            return null;
        }
        if (allAssets.size() == 1) {
            return (String)allAssets.get(0);
        }
        Double \u03b1 = assetsFlowConfig.get\u03911();
        if (MediaEntranceCreativesServiceImpl.twoCondition(uid, assetsFlowConfig)) {
            \u03b1 = assetsFlowConfig.get\u03912();
        }
        Boolean flag = false;
        if (MediaEntranceCreativesServiceImpl.oneCondition(uid, assetsFlowConfig)) {
            flag = true;
        }
        ArrayList<AssetsSort> assetsSortList = new ArrayList<AssetsSort>();
        ArrayList futures = Lists.newArrayList();
        for (String assetsId : allAssets) {
            Double final\u0391 = \u03b1;
            Boolean finalFlag = flag;
            Future<AssetsSort> future = this.pool.submit(() -> {
                AssetsSort assetsSort = new AssetsSort();
                assetsSort.setAssetId(assetsId);
                if (finalFlag.booleanValue()) {
                    assetsSort.setCtr(this.ctr(positionId, assetsId));
                } else {
                    assetsSort.setCtr(this.newCtr(positionId, assetsId, uid, final\u0391));
                }
                return assetsSort;
            });
            futures.add(future);
        }
        for (Future future : futures) {
            try {
                AssetsSort assetsSort = (AssetsSort)future.get();
                assetsSortList.add(assetsSort);
            }
            catch (InterruptedException | ExecutionException e) {
                if (!log.isErrorEnabled()) continue;
                log.error("get:", (Throwable)e);
            }
        }
        Collections.sort(assetsSortList);
        return ((AssetsSort)assetsSortList.get(0)).getAssetId();
    }

    public static void main(String[] args) {
        AssetsFlowConfig assetsFlowConfig = new AssetsFlowConfig();
        assetsFlowConfig.setOneCondition(30);
        assetsFlowConfig.setTwoCondition(40);
        assetsFlowConfig.setThreeCondition(50);
        assetsFlowConfig.set\u03911(0.9);
        assetsFlowConfig.set\u03912(0.8);
        System.out.println(JSON.toJSONString((Object)assetsFlowConfig));
        for (int i = 70; i < 1200; ++i) {
            int hashCode = (i + "").hashCode();
            int abs = Math.abs(hashCode % 100);
            if (abs <= 40 || abs >= 50) continue;
            System.out.println(i + "---" + abs);
        }
    }

    private Double ctr(String positionId, String assetsId) {
        return this.findByKeyCtr(assetsId, MediaEntranceCreativesBuider.positionAllAssets(positionId));
    }

    private Double newCtr(String positionId, String assetsId, String uid, Double \u03b1) {
        Double positionCtr = this.findByKeyCtr(assetsId, MediaEntranceCreativesBuider.positionAllAssets(positionId));
        Double userCtr = this.findByKeyCtr(assetsId, MediaEntranceCreativesBuider.userAllAssets(uid));
        return \u03b1 * positionCtr + (1.0 - \u03b1) * userCtr;
    }

    private Double findByKeyCtr(String assetsId, KeyGenerator keyGenerator) {
        AssetsCounter assetsCounter = (AssetsCounter)this.fetcher.hfetchWithSelector(keyGenerator, assetsId, AssetsCounter.class, 2);
        if (assetsCounter == null || assetsCounter.getExposurePv() == 0) {
            assetsCounter = new AssetsCounter();
        }
        if (assetsCounter.getExposurePv() - assetsCounter.getClickPv() < 0) {
            return MediaEntranceCreativesServiceImpl.betasampler(assetsCounter.getClickPv() + 1, 1.0);
        }
        return MediaEntranceCreativesServiceImpl.betasampler(assetsCounter.getClickPv() + 1, 1 + assetsCounter.getExposurePv() - assetsCounter.getClickPv());
    }

    public static double betasampler(double alpha, double beta) {
        BetaDistribution betas = new BetaDistribution(alpha, beta);
        return betas.sample();
    }

    private Boolean checkPosition(String positionId) {
        if (StringUtils.isEmpty((String)positionId)) {
            return false;
        }
        String result = (String)this.fetcher.fetchWithSelector(MediaEntranceCreativesBuider.tmepPosition(), String.class, 2);
        if (StringUtils.isEmpty((String)positionId)) {
            return false;
        }
        List<String> list = Arrays.asList(result.split(","));
        if (list.contains(positionId)) {
            return true;
        }
        return false;
    }

    private AssetsFlowConfig getAssetsFlowConfig() {
        AssetsFlowConfig result = (AssetsFlowConfig)this.fetcher.fetchWithSelector(MediaEntranceCreativesBuider.tmepConfig(), AssetsFlowConfig.class, 2);
        return result;
    }

    private static boolean oneCondition(String uid, AssetsFlowConfig assetsFlowConfig) {
        if (StringUtils.isEmpty((String)uid)) {
            return false;
        }
        int hashCode = uid.hashCode();
        int abs = Math.abs(hashCode % 100);
        return abs < assetsFlowConfig.getOneCondition();
    }

    private static boolean twoCondition(String uid, AssetsFlowConfig assetsFlowConfig) {
        if (StringUtils.isEmpty((String)uid)) {
            return false;
        }
        int hashCode = uid.hashCode();
        int abs = Math.abs(hashCode % 100);
        return abs < assetsFlowConfig.getTwoCondition();
    }

    private static boolean threeCondition(String uid, AssetsFlowConfig assetsFlowConfig) {
        if (StringUtils.isEmpty((String)uid)) {
            return false;
        }
        int hashCode = uid.hashCode();
        int abs = Math.abs(hashCode % 100);
        return abs < assetsFlowConfig.getThreeCondition();
    }

    public String get(Map<String, Double> map) {
        Map.Entry<String, Double> entry;
        if (MapUtils.isEmpty(map)) {
            return null;
        }
        double chanceRate = RandomUtils.nextDouble((double)0.0, (double)MediaEntranceCreativesServiceImpl.sum(map));
        Set<Map.Entry<String, Double>> entrySet = map.entrySet();
        double rate = 0.0;
        Iterator<Map.Entry<String, Double>> var7 = entrySet.iterator();
        do {
            if (!var7.hasNext()) {
                return entrySet.iterator().next().getKey();
            }
            entry = var7.next();
        } while ((rate = MediaEntranceCreativesServiceImpl.add(rate, entry.getValue())) < chanceRate);
        return entry.getKey();
    }

    private static double sum(Map<String, Double> rates) {
        double sum = 0.0;
        for (Double d : rates.values()) {
            if (!(d > 0.0)) continue;
            sum = MediaEntranceCreativesServiceImpl.add(sum, d);
        }
        return sum;
    }

    public static double add(double ... values) {
        double val1 = values[0];
        for (int i = 1; i < values.length; ++i) {
            val1 = BigDecimal.valueOf(val1).add(BigDecimal.valueOf(values[i])).setScale(4, 1).doubleValue();
        }
        return val1;
    }
}

