package com.bxm.adx.common;

/**
 * <p>
 * 广告位场景
 * </p>
 *
 * @author zhengwangeng
 * @since 2019-12-17
 */
public enum PositionSceneTypeEnum {

    /**
     * 信息流
     */
    INFORMATION_FLOW(1, "信息流"),

    /**
     * 开屏
     */
    BOOT(2, "开屏"),

    /**
     * banner
     */
    BANNER(3, "banner"),

    /**
     * 插屏
     */
    SCREEN(4, "插屏"),

    /**
     * 浮标
     */
    ICON(5, "浮标"),

    /**
     * 按钮
     */
    BUTTON(6, "按钮"),

    /**
     * 搜索
     */
    SEARCH(7, "搜索"),

    /**
     * 激励视频
     */
    INSPIRE_VIDEO(8, "激励视频"),

    /**
     * 视频
     */
    VIDEO(9, "视频"),

    /**
     * 自渲染信息流
     */
    INFORMATION_FLOW_SELF_RENDERING(11, "自渲染信息流"),

    /**
     * 自渲染
     */
    SELF_RENDERING(13, "自渲染"),

    /**
     * 沉浸式信息流视频
     */
    INFORMATION_FLOW_IMMERSIVE_VIDEO(14, "沉浸式信息流视频"),
    ;

    private Integer type;

    private String desc;

    public Integer getType() {
        return type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    PositionSceneTypeEnum(Integer type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    public static PositionSceneTypeEnum get(Integer type) {
        if (null == type) {
            return null;
        }
        for (PositionSceneTypeEnum anEnum : values()) {
            if (anEnum.getType().equals(type)) {
                return anEnum;
            }
        }
        return null;
    }
}
