package com.bxm.adx.common.adapter.builder;

import com.alibaba.fastjson.JSON;
import com.bxm.adx.common.AdxProperties;
import com.bxm.adx.common.entity.AdxCounterParam;
import com.bxm.adx.common.sell.BidRequest;
import com.bxm.adx.common.sell.BidResponse;
import com.bxm.adx.common.sell.position.Position;
import com.bxm.adx.common.sell.position.PositionService;
import com.bxm.adx.common.sell.request.Device;
import com.bxm.adx.common.sell.response.*;
import com.bxm.adx.common.sell.ssp.SspResponse;
import com.bxm.adx.common.sell.ssp.resp.*;
import com.bxm.adx.common.utils.UrlUtils;
import com.bxm.warcar.utils.StringHelper;
import com.bxm.warcar.utils.UUIDHelper;
import com.bxm.warcar.web.util.TextEncrypted;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang.RandomStringUtils;

import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

/**
 * Created by Arei on 2020/4/10.
 */
@Component
@Slf4j
public class ConcreteSspResponseBuilder extends SspResponseBuilder {

    private AdxProperties properties;
    private PositionService positionService;
    private MonitorBuilder monitorBuilder;

    public ConcreteSspResponseBuilder(AdxProperties properties, PositionService positionService, MonitorBuilder monitorBuilder) {
        this.properties = properties;
        this.positionService = positionService;
        this.monitorBuilder = monitorBuilder;
    }

    @Override
    public void buildResult(BidResponse response, SspResponse sspResponse) {
        List<SeatBid> seatBids = response.getSeat_bid();
        int result = 0;

        if (CollectionUtils.isEmpty(seatBids)) {
            result = -1;
        }
        sspResponse.setResult(result);
    }

    @Override
    public void buildMsg(BidResponse response, SspResponse sspResponse) {
        List<SeatBid> seatBids = response.getSeat_bid();
        String msg = "";
        if (CollectionUtils.isEmpty(seatBids)) {
            msg = "无";
        }
        sspResponse.setMsg(msg);
    }

    @Override
    public void buildAds(BidResponse e, BidRequest bidRequest, SspResponse sspResponse) {
        List<SeatBid> seatBids = e.getSeat_bid();
        if (CollectionUtils.isEmpty(seatBids)) {
            return;
        }
        AdxCounterParam param = null;
        if (null != bidRequest) {
            Device device = bidRequest.getDevice();
            if (null != device) {
                String os = null;
                String osStr = device.getOs();
                if (!StringUtils.isEmpty(osStr)) {
                    if ("ios".equalsIgnoreCase(osStr)) {
                        os = "2";
                    }
                    if ("android".equalsIgnoreCase(osStr)) {
                        os = "1";
                    }
                }

                param = AdxCounterParam.builder()
                        .anid(device.getDpid())
                        .anid_md5(device.getDpid_md5())
                        .idfa(device.getIdfa())
                        .idfa_md5(device.getIdfa_md5())
                        .imei(device.getImei())
                        .imei_md5(device.getImei_md5())
                        .oaid(device.getOaid())
                        .mac(device.getMac())
                        .os(os)
                        .ip(device.getIp())
                        .ua(device.getUa())//埋点加密自己做了转码
//                            .ua(URLEncoder.encode(device.getUa(), "UTF-8"))
                        .build();
            }
        }
        String url = properties.getCounterBaseUrl();

        List<com.bxm.adx.common.sell.ssp.resp.Ad> ads = new ArrayList<>(seatBids.size());
        for (SeatBid seatBid : seatBids) {
            List<Bid> bids = seatBid.getBid();
            for (Bid bid : bids) {

                if (param == null) {
                    param = AdxCounterParam.builder().build();
                }

                param.setBidid(e.getId());
                param.setDspid(seatBid.getDspId().toString());
                param.setCreateid(bid.getCreate_id());
                param.setTagid(bid.getTag_id());
                param.setScene(bid.getScene());
                param.setWin(bid.getPrice_str());

                com.bxm.adx.common.sell.ssp.resp.Ad ad = new com.bxm.adx.common.sell.ssp.resp.Ad();
                ad.setId(RandomStringUtils.randomAlphanumeric(8));
                ad.setPlace_token(bid.getTag_id());
                ad.setAction(bid.getC_type());
                ad.setW(bid.getW());
                ad.setH(bid.getH());
                // FIXME: 2020/11/4 广告位获取问题
                Position position = positionService.getByPositionId(ad.getPlace_token());
                Config config = new Config();
                ad.setConfig(config);
                config.setBoot_time(position.getBootTime());
                config.setClick_video_action(position.getClickVideoAction());
                config.setShow_ad_logo(position.getIsShowAdLogo());
                config.setShow_endpage(position.getIsShowEndpage());
                if (null != position) {
                    if (null != position.getInformationFlowTemplate())
                        ad.setTemplate(position.getInformationFlowTemplate());
                }

                ad.setClick_trackers(monitorBuilder.fillClickMonitor(bid.getClick_monitors(), url, param));

                ad.setImp_trackers(monitorBuilder.fillImpMonitor(bid.getImp_monitors(), url, param));

                ad.setDeeplink_url(bid.getDeep_link_url());
                if (StringUtils.isNotEmpty(bid.getDeep_link_url())) {
                    ad.setDp_tracker(monitorBuilder.fillDpMonitor(bid.getDpMonitor(), url, param));
                }
                //支持deeplink监测和sdk版本控制
                if (!StringHelper.isNewVersion("3.1.0", bidRequest.getSdk_ver())) {
                    if (null != ad.getDp_tracker()) {
                        List<String> dpSuccessUrls = ad.getDp_tracker().getAwk_success_urls();
                        if (!CollectionUtils.isEmpty(dpSuccessUrls)) {
                            List<String> cts = ad.getClick_trackers();
                            if (!CollectionUtils.isEmpty(cts)) {
                                cts.addAll(dpSuccessUrls);
                            } else {
                                cts = dpSuccessUrls;
                            }
                            ad.setClick_trackers(cts);
                        }
                    }
                }
                if (ad.getAction() == 2 || ad.getAction() == 3 || ad.getAction() == 9 || ad.getAction() == 11) {
                    ad.setAppTracker(monitorBuilder.fillAppTracker(bid.getApp_monitor(), url, param));
                }
                ad.setTarget_url(bid.getClick_through_url());

                ad.setType(bid.getType());
                ad.setApk_name(bid.getApk_name());
                ad.setApp_bundle(bid.getBundle());
                com.bxm.adx.common.sell.ssp.resp.Native an = new com.bxm.adx.common.sell.ssp.resp.Native();
                List<com.bxm.adx.common.sell.ssp.resp.Asset> assets = new ArrayList<>();
                com.bxm.adx.common.sell.response.Native sn = bid.getA_native();
                List<com.bxm.adx.common.sell.response.Asset> snAssets = sn.getAssets();
                for (com.bxm.adx.common.sell.response.Asset sa : snAssets) {
                    com.bxm.adx.common.sell.ssp.resp.Asset asset = new com.bxm.adx.common.sell.ssp.resp.Asset();
                    asset.setType(sa.getType());
                    asset.setId(sa.getId());
                    asset.setRequired(sa.getRequired());
                    switch (sa.getType()) {
                        case 1:
                            com.bxm.adx.common.sell.ssp.resp.Text title = new com.bxm.adx.common.sell.ssp.resp.Text();
                            title.setText(sa.getText().getText());
                            asset.setText(title);
                            break;
                        case 2:
                            com.bxm.adx.common.sell.ssp.resp.Text content = new com.bxm.adx.common.sell.ssp.resp.Text();
                            content.setText(sa.getText().getText());
                            asset.setText(content);
                            break;
                        case 3:
                            com.bxm.adx.common.sell.ssp.resp.Text buttonText = new com.bxm.adx.common.sell.ssp.resp.Text();
                            buttonText.setText(sa.getText().getText());
                            asset.setText(buttonText);
                            break;
                        case 6:
                            com.bxm.adx.common.sell.ssp.resp.Image image = new com.bxm.adx.common.sell.ssp.resp.Image();
                            image.setUrl(sa.getImg().getUrl());
                            image.setH(sa.getImg().getH());
                            image.setW(sa.getImg().getW());
                            asset.setImg(image);
                            break;
                        case 7:
                            com.bxm.adx.common.sell.ssp.resp.Image limg = new com.bxm.adx.common.sell.ssp.resp.Image();
                            limg.setUrl(sa.getImg().getUrl());
                            limg.setH(sa.getImg().getH());
                            limg.setW(sa.getImg().getW());
                            asset.setImg(limg);
                            break;
                        case 8:
                            com.bxm.adx.common.sell.ssp.resp.Image bimg = new com.bxm.adx.common.sell.ssp.resp.Image();
                            bimg.setUrl(sa.getImg().getUrl());
                            bimg.setH(sa.getImg().getH());
                            bimg.setW(sa.getImg().getW());
                            asset.setImg(bimg);
                            break;
                        case 12:
                            com.bxm.adx.common.sell.ssp.resp.Video video = new com.bxm.adx.common.sell.ssp.resp.Video();
                            com.bxm.adx.common.sell.response.Video v = sa.getVideo();
                            BeanUtils.copyProperties(v, video);

                            VMonitor vm = new VMonitor();
                            if (null != v.getV_monitor()) {
                                BeanUtils.copyProperties(v.getV_monitor(), vm);
                            }

                            video.setV_monitor(monitorBuilder.fillVMonitor(vm, url, param));
                            asset.setVideo(video);
                            break;
                    }
                    assets.add(asset);
                }
                an.setAssets(assets);
                ad.setA_native(an);
                ads.add(ad);
            }
        }
        sspResponse.setAds(ads);
    }
}
