package com.bxm.adx.common.ingetration;

import com.bxm.adxcounter.facade.model.AdxCounterDTO;
import com.bxm.adxcounter.facade.service.AdxCounterService;
import org.springframework.cloud.openfeign.EnableFeignClients;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.ResponseEntity;

/**
 * @author allen
 * @date 2020-10-30
 * @since 1.0
 */
@Configuration
@EnableFeignClients("com.bxm.adxcounter.facade")
public class AdxCounterServiceIntegration {

    private final AdxCounterService service;

    public AdxCounterServiceIntegration(AdxCounterService service) {
        this.service = service;
    }

    public ResponseEntity counter(AdxCounterDTO counter) {
        return service.counter(counter);
    }
}
