package com.bxm.adx.common.sell.position;

import com.bxm.adx.common.sell.app.AppService;
import com.bxm.adx.common.sell.ssp.SspRequest;
import com.bxm.adx.common.sell.ssp.req.App;
import com.bxm.mccms.facade.model.pushable.PositionInteractAppentranceRefCacheVO;
import lombok.extern.slf4j.Slf4j;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.StringUtils;

/**
 * @author allen
 * @since 2019-12-18
 */
@Configuration
@Slf4j
public class PositionServiceImpl implements PositionService {

    private final PositionDao positionDao;
    private final AppService appService;

    public PositionServiceImpl(PositionDao positionDao, AppService appService) {
        this.positionDao = positionDao;
        this.appService = appService;
    }

    @Override
    public Position getByAppPositionId(String appPositionId) {
        return positionDao.getByAppPositionId(appPositionId);
    }

    @Override
    public Position getByPositionId(String positionId) {
        //TODO 这里有可能传的是appPositionId
        Position position = positionDao.getByPositionId(positionId);
        if (position == null) {
            position = getByAppPositionId(positionId);
        }
        return position;
    }

    @Override
    public void verifyPosition(Position position, SspRequest sspRequest) {
        String appId = null;
        String packageName = null;
        if (null != sspRequest) {
            App app = sspRequest.getApp();
            if (null != app) {
                packageName = app.getBundle();
            }
        }
        if (StringUtils.isEmpty(packageName)) {
            if (log.isWarnEnabled()) {
                log.warn("app packageName is not exist");
            }
            return;
        }

        if (null != position) {
            appId = position.getAppId();
        }
        if (StringUtils.isEmpty(appId)) {
            if (log.isWarnEnabled()) {
                log.warn("app position is not exist");
            }
            return;
        }

        com.bxm.adx.facade.rule.app.App app = appService.getAppById(appId);
        if (null == app) {
            if (log.isWarnEnabled()) {
                log.warn("appId: {} is not exist", appId);
            }
        } else {
            String realPackName = app.getAppPackageName();
            if (StringUtils.isEmpty(realPackName)) {
                if (log.isWarnEnabled()) {
                    log.warn("appId: {} realPackName is null", appId);
                }
            } else {
                if (realPackName.equalsIgnoreCase(packageName)) {
                    return;
                } else {
                    if (log.isWarnEnabled()) {
                        String posId = position.getPositionId();
                        if (StringUtils.isEmpty(posId)) {
                            posId = "-";
                        }
                        log.warn("verify err, pos={},real={},now={}", posId, realPackName, packageName);
                    }
                }
            }
        }
    }

    @Override
    public PositionInteractAppentranceRefCacheVO getInteractByPositionId(String positionId) {
        return positionDao.getInteractByPositionId(positionId);
    }
}
