package com.bxm.adx.common.ip;

import com.bxm.warcar.ip.IP;
import com.bxm.warcar.ip.IpLibrary;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

/**
 * @author allen
 * @date 2019/4/12
 * @since 1.0.0
 */
@Service
public class DefaultIpServiceImpl implements IpService {

    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultIpServiceImpl.class);

    @Autowired
    @Qualifier("aliyunIpLibrary")
    private IpLibrary ipLibrary;

    @Override
    public IP analyze(String ip) {
        try {
            IP ipip = ipLibrary.find(ip);
            if (ipip == null){
                return getDefault();
            }
            return ipip;
        } catch (Exception e) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error("getIp: ", e);
            }
            return getDefault();
        }
    }

    private IP getDefault() {
        return new IP();
    }
}
