package com.bxm.adx.common.market;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

import org.apache.commons.collections.CollectionUtils;
import org.springframework.context.annotation.Configuration;

import com.bxm.adx.common.AdxConstants;
import com.bxm.adx.common.AdxProperties;
import com.bxm.adx.common.OpenlogConstants;
import com.bxm.adx.common.adapter.AdxContextFactory;
import com.bxm.adx.common.sell.BidRequest;
import com.bxm.adx.common.sell.BidResponse;
import com.bxm.adx.common.sell.builder.BuildAttribute;
import com.bxm.adx.common.sell.builder.BuildAttributeStringMacrosHandler;
import com.bxm.adx.common.sell.response.AppMonitor;
import com.bxm.adx.common.sell.response.Bid;
import com.bxm.adx.common.sell.response.ClickMonitor;
import com.bxm.adx.common.sell.response.DpMonitor;
import com.bxm.adx.common.sell.response.ImpMonitor;
import com.bxm.adx.common.sell.response.SeatBid;

/**
 * @author fgf
 * @date 2022/6/6
 **/
@Configuration
public class MonitorWrapper {
    private final AdxProperties adxProperties;
    private final BuildAttributeStringMacrosHandler macrosHandler;

    public MonitorWrapper(AdxProperties adxProperties, BuildAttributeStringMacrosHandler macrosHandler) {
        this.adxProperties = adxProperties;
        this.macrosHandler = macrosHandler;
    }

    public void monitorWrapper(BidResponse bidResponse) {
        if (Objects.isNull(bidResponse) || CollectionUtils.isEmpty(bidResponse.getSeat_bid())) {
            return;
        }
        BidRequest bidRequest = AdxContextFactory.get().getBidRequest();
        BuildAttribute buildAttribute = new BuildAttribute().setAdxResponse(bidResponse).setSspRequest(bidRequest);

        for (SeatBid seatBid : bidResponse.getSeat_bid()) {
            buildAttribute.setDspId(Objects.nonNull(seatBid.getDspId()) ? seatBid.getDspId().toString() : null);
            buildAttribute.setConfigId(Objects.nonNull(seatBid.getConfigId()) ? seatBid.getConfigId().toString() : null);
            for (Bid bid : seatBid.getBid()) {
                List<ImpMonitor> impMonitors = bid.getImp_monitors();
                if (CollectionUtils.isEmpty(impMonitors)) {
                    impMonitors = new ArrayList<>();
                }

                ImpMonitor impMonitor = new ImpMonitor();
                String impUrl = adxProperties.getOpenLog().create(OpenlogConstants.Mt.IMP_MT);
                impUrl = macrosHandler.replaceAll(impUrl, buildAttribute.setMt(OpenlogConstants.Mt.IMP_MT));
                if (AdxConstants.needReplacePrice(bidRequest.getMediaId())) {
                    String price = "0";
                    if (Objects.nonNull(bid.getPrice())) {
                        price = bid.getPrice().toString();
                    }
                    impUrl = impUrl.replace(OpenlogConstants.Macros.PRICE, price);
                }
                impMonitor.setImp_monitor_url(impUrl);
                impMonitors.add(impMonitor);
                bid.setImp_monitors(impMonitors);

                List<ClickMonitor> clickMonitors = bid.getClick_monitors();
                if (CollectionUtils.isEmpty(clickMonitors)) {
                    clickMonitors = new ArrayList<>();
                }

                ClickMonitor clickMonitor = new ClickMonitor();
                String clickUrl = adxProperties.getOpenLog().create(OpenlogConstants.Mt.CLICK_MT);
                clickMonitor.setClick_monitor_url(macrosHandler.replaceAll(clickUrl, buildAttribute.setMt(OpenlogConstants.Mt.CLICK_MT)));
                clickMonitors.add(clickMonitor);
                bid.setClick_monitors(clickMonitors);

                DpMonitor dpMonitor = bid.getDpMonitor();
                dpMonitorWrapper(dpMonitor, buildAttribute);
                bid.setDpMonitor(dpMonitor);

                AppMonitor appMonitor = bid.getApp_monitor();
                appMonitorWrapper(appMonitor, buildAttribute);
                bid.setApp_monitor(appMonitor);
            }
        }
    }

    private void dpMonitorWrapper(DpMonitor dpMonitor, BuildAttribute buildAttribute) {
        if (Objects.nonNull(dpMonitor)) {
            String dpSuccessUrl = adxProperties.getOpenLog().create(OpenlogConstants.Mt.DP_SUCCESS_MT, "price", "chgtypm", "chgtypd");
            String dpFailUrl = adxProperties.getOpenLog().create(OpenlogConstants.Mt.DP_FAIL_MT, "price", "chgtypm", "chgtypd");
            String dpStartUrl = adxProperties.getOpenLog().create(OpenlogConstants.Mt.DP_START_MT, "price", "chgtypm", "chgtypd");

            List<String> dpSuccessList = dpMonitor.getAwk_success_urls();
            if (Objects.isNull(dpSuccessList)) {
                dpSuccessList = new ArrayList<>();
            }
            dpSuccessList.add(macrosHandler.replaceAll(dpSuccessUrl, buildAttribute));

            List<String> dpFailList = dpMonitor.getAwk_fail_urls();
            if (Objects.isNull(dpFailList)) {
                dpFailList = new ArrayList<>();
            }
            dpFailList.add(macrosHandler.replaceAll(dpFailUrl, buildAttribute));

            List<String> dpStartList = dpMonitor.getAwk_start_urls();
            if (Objects.isNull(dpStartList)) {
                dpStartList = new ArrayList<>();
            }
            dpStartList.add(macrosHandler.replaceAll(dpStartUrl, buildAttribute));

            dpMonitor.setAwk_success_urls(dpSuccessList);
            dpMonitor.setAwk_fail_urls(dpFailList);
            dpMonitor.setAwk_start_urls(dpStartList);
        }
    }

    private void appMonitorWrapper(AppMonitor appMonitor, BuildAttribute buildAttribute) {
        if (Objects.nonNull(appMonitor)) {
            String downloadStart = adxProperties.getOpenLog().create(OpenlogConstants.Mt.DOWN_START, "price", "chgtypm", "chgtypd");
            String downloadFinish = adxProperties.getOpenLog().create(OpenlogConstants.Mt.DOWN_FINISH, "price", "chgtypm", "chgtypd");
            String installStart = adxProperties.getOpenLog().create(OpenlogConstants.Mt.INSTALL_START, "price", "chgtypm", "chgtypd");
            String installFinish = adxProperties.getOpenLog().create(OpenlogConstants.Mt.INSTALL_FINISH, "price", "chgtypm", "chgtypd");

            List<String> ds_urls = appMonitor.getDs_urls();
            List<String> df_urls = appMonitor.getDf_urls();
            List<String> sf_urls = appMonitor.getSf_urls();
            List<String> ss_urls = appMonitor.getSs_urls();
            if (Objects.isNull(df_urls)) {
                df_urls = new ArrayList<>();
            }
            df_urls.add(macrosHandler.replaceAll(downloadFinish, buildAttribute));
            if (Objects.isNull(ds_urls)) {
                ds_urls = new ArrayList<>();
            }
            ds_urls.add(macrosHandler.replaceAll(downloadStart, buildAttribute));
            if (Objects.isNull(ss_urls)) {
                ss_urls = new ArrayList<>();
            }
            ss_urls.add(macrosHandler.replaceAll(installStart, buildAttribute));
            if (Objects.isNull(sf_urls)) {
                sf_urls = new ArrayList<>();
            }
            sf_urls.add(macrosHandler.replaceAll(installFinish, buildAttribute));

            appMonitor.setSf_urls(sf_urls);
            appMonitor.setDf_urls(df_urls);
            appMonitor.setSs_urls(ss_urls);
            appMonitor.setDs_urls(ds_urls);
        }
    }
}
