package com.bxm.adx.common.openlog.event.internal;

import java.util.EventObject;

import com.bxm.adx.common.sell.BidRequest;
import com.bxm.adx.common.sell.BidResponse;

/**
 * adx竞价返回事件
 * @author fgf
 * @date 2022/6/2
 */
public class AdxBidEvent extends EventObject {
    private final BidRequest sspRequest;
    private final BidResponse adxResponse;
    /**
     * Constructs a prototypical Event.
     *
     * @param source The object on which the Event initially occurred.
     * @param sspRequest
     * @param adxResponse
     * @throws IllegalArgumentException if source is null.
     */
    public AdxBidEvent(Object source, BidRequest sspRequest, BidResponse adxResponse) {
        super(source);
        this.sspRequest = sspRequest;
        this.adxResponse = adxResponse;
    }

    public BidRequest getSspRequest() {
        return sspRequest;
    }

    public BidResponse getAdxResponse() {
        return adxResponse;
    }
}
