package com.bxm.adx.common.openlog.listener.internal;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;

import com.bxm.adx.common.AdxProperties;
import com.bxm.adx.common.OpenlogConstants;
import com.bxm.adx.common.openlog.event.internal.AdxBidEvent;
import com.bxm.adx.common.sell.builder.BuildAttribute;
import com.bxm.adx.common.sell.builder.BuildAttributeStringMacrosHandler;
import com.bxm.openlog.extension.client.OpenLogClient;
import com.bxm.warcar.integration.eventbus.EventListener;
import com.bxm.warcar.integration.eventbus.core.AllowConcurrentEvents;
import com.bxm.warcar.integration.eventbus.core.Subscribe;

/**
 * @author fgf
 * @date 2022/6/1
 **/
@Configuration
public class DoAdxBidEventListener implements EventListener<AdxBidEvent> {
    private OpenLogClient openLogClient;
    private final AdxProperties properties;
    private final BuildAttributeStringMacrosHandler macrosHandler;

    public DoAdxBidEventListener(AdxProperties properties, BuildAttributeStringMacrosHandler macrosHandler) {
        this.properties = properties;
        this.macrosHandler = macrosHandler;
    }

    @Autowired
    public void setOpenLogClient(OpenLogClient openLogClient) {
        this.openLogClient = openLogClient;
    }

    @Override
    @Subscribe
    @AllowConcurrentEvents
    public void consume(AdxBidEvent event) {
        String url = properties.getOpenLog().create(OpenlogConstants.Mt.ADX_RESPONSE_MT, "dspid", "chgtypm", "chgtypd");
        BuildAttribute attribute = new BuildAttribute(OpenlogConstants.Mt.ADX_RESPONSE_MT)
                .setSspRequest(event.getSspRequest())
                .setAdxResponse(event.getAdxResponse());
        url = macrosHandler.replaceAll(url, attribute);
        openLogClient.asyncRequest(url);
    }
}
