package com.bxm.adx.common.sell.response;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * @author fgf
 * @date 2021/9/6
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class DownloadInfo implements Serializable {
    public static final Byte ANDROID = 1;
    public static final Byte IOS = 2;
    /**
     * 下载地址
     */
    private String downloadUrl;

    /**
     * 应用名称
     */
    private String appName;

    /**
     * 应用包名
     */
    private String appPackageName;

    /**
     * 应用介绍
     */
    private String appDesc;

    /**
     * 应用大小
     */
    private BigDecimal appSize;

    /**
     * 开发者名称
     */
    private String developerName;

    /**
     * 版本号
     */
    private String version;

    /**
     * 隐私协议URL
     */
    private String privacyAgreementUrl;

    /**
     * 用户权限URL
     */
    private String userRightsUrl;

    /**
     * 试玩时长
     */
    private Integer trialTime;

    /**
     * deeplink地址
     */
    private String deeplinkUrl;

    /**
     * 应用Icon
     */
    private String appIconUrl;
    /**
     * 系统类型：1-安卓，2-IOS
     */
    private Byte osType;
}
