package com.bxm.adx.common.sell.simple;

import com.bxm.adx.common.CacheKeys;
import com.bxm.adx.common.sell.BidRequest;
import com.bxm.warcar.cache.Fetcher;
import com.bxm.warcar.cache.Updater;
import org.springframework.stereotype.Service;

/**
 * Created by Arei on 2020/9/18.
 *
 * 为前端开放的bidding/simple接口用（bxm-simple-plugin）
 *
 */
@Service
public class SimpleService {
    private final Updater updater;
    private final Fetcher fetcher;

    public SimpleService(Updater updater, Fetcher fetcher) {
        this.updater = updater;
        this.fetcher = fetcher;
    }

    public void updateRequest(BidRequest request) {
        updater.update(CacheKeys.getBidRequestKeyGenerator(request.getId()), request, 3600);
    }

    public BidRequest getRequest(String bidid) {
        return fetcher.fetch(CacheKeys.getBidRequestKeyGenerator(bidid), BidRequest.class);
    }
}
