/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adx.common.buy.dispatcher;

import com.bxm.adx.common.CacheKeys;
import com.bxm.adx.common.buy.dispatcher.Dispatcher;
import com.bxm.adx.common.buy.dispatcher.DispatcherAB;
import com.bxm.adx.common.buy.dispatcher.DispatcherDao;
import com.bxm.adx.common.buy.dsp.DspService;
import com.bxm.adx.common.sell.position.Position;
import com.bxm.adx.common.sell.position.PositionService;
import com.bxm.mccms.facade.model.pushable.DispatcherDspCacheVO;
import com.bxm.warcar.cache.Fetcher;
import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.cache.Updater;
import com.bxm.warcar.cache.push.Pushable;
import com.bxm.warcar.integration.pushable.annotation.CachePush;
import com.bxm.warcar.utils.JsonHelper;
import com.bxm.warcar.utils.KeyBuilder;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.collections.MapUtils;
import org.springframework.stereotype.Component;

@CachePush(value="DISPATCHER")
@Component
public class DispatcherDaoImpl
implements DispatcherDao,
Pushable {
    private final Fetcher fetcher;
    private final Updater updater;
    private final PositionService positionService;
    private final DspService dspService;
    private final DispatcherAB dispatcherAB;

    public DispatcherDaoImpl(Fetcher fetcher, Updater updater, PositionService positionService, DspService dspService, DispatcherAB dispatcherAB) {
        this.fetcher = fetcher;
        this.updater = updater;
        this.positionService = positionService;
        this.dspService = dspService;
        this.dispatcherAB = dispatcherAB;
    }

    @Override
    public Collection<Dispatcher> get(String positionId) {
        Map map = this.fetcher.hfetchall(CacheKeys.Dispather.getKeyGenerator(positionId), Dispatcher.class);
        if (MapUtils.isEmpty((Map)map)) {
            map = this.fetcher.hfetchall(this.getKeyGenerator(positionId), Dispatcher.class);
        }
        return MapUtils.isNotEmpty((Map)map) ? map.values() : null;
    }

    @Override
    public Dispatcher getByAppPosId(String appPosId, String dspCode) {
        Dispatcher dispatcher = (Dispatcher)this.fetcher.hfetch(CacheKeys.Dispather.getKeyGeneratorByAppPosId(appPosId), dspCode, Dispatcher.class);
        return Objects.isNull(dispatcher) ? (Dispatcher)this.fetcher.hfetch(this.getKeyGeneratorByAppPosId(appPosId), dspCode, Dispatcher.class) : dispatcher;
    }

    @Override
    public Dispatcher get(String positionId, String dspId) {
        Dispatcher dispatcher = (Dispatcher)this.fetcher.hfetch(CacheKeys.Dispather.getKeyGenerator(positionId), dspId, Dispatcher.class);
        return Objects.isNull(dispatcher) ? (Dispatcher)this.fetcher.hfetch(this.getKeyGenerator(positionId), dspId, Dispatcher.class) : dispatcher;
    }

    @Override
    public Collection<DispatcherDspCacheVO> getDispatchersByConfigId(String positionId, Long configId) {
        return this.dispatcherAB.getDispatchersByConfigId(positionId, configId);
    }

    @Override
    public Dispatcher getByConfig(String positionId, String dspId, Long configId) {
        return (Dispatcher)this.fetcher.hfetch(CacheKeys.Dispather.getKeyGeneratorByConfig(positionId), configId + "-" + dspId, Dispatcher.class);
    }

    public void push(Map<String, Object> parameters, byte[] data) {
        Object o = parameters.get("positionId");
        if (Objects.isNull(o)) {
            return;
        }
        String positionId = Objects.toString(o);
        Dispatcher dispatcher = (Dispatcher)JsonHelper.convert((byte[])data, Dispatcher.class);
        String dspId = Objects.toString(dispatcher.getDspId());
        String dspCode = this.dspService.get(Long.valueOf(dspId)).getDspCode();
        this.updater.hremove(this.getKeyGenerator(positionId), new String[]{dspId});
        this.updater.hupdate(this.getKeyGenerator(positionId), dspId, (Object)dispatcher);
        Position position = this.positionService.getByPositionId(positionId);
        this.updater.hremove(this.getKeyGeneratorByAppPosId(position.getAppPositionId()), new String[]{dspCode});
        this.updater.hupdate(this.getKeyGeneratorByAppPosId(position.getAppPositionId()), dspCode, (Object)dispatcher);
    }

    private KeyGenerator getKeyGenerator(String positionId) {
        return () -> KeyBuilder.build((Object[])new Object[]{"ADX", "DISPATHER", "PID", positionId});
    }

    private KeyGenerator getKeyGeneratorByAppPosId(String appPosId) {
        return () -> KeyBuilder.build((Object[])new Object[]{"ADX", "DISPATHER", "APPID", appPosId});
    }
}

