/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adx.common.cipher;

import com.bxm.adx.common.cipher.CipherService;
import com.bxm.warcar.cache.Fetcher;
import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.cache.Updater;
import com.bxm.warcar.utils.KeyBuilder;
import com.bxm.warcar.utils.UUIDHelper;
import java.nio.charset.StandardCharsets;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class CipherServiceImpl
implements CipherService {
    private static final Logger log = LoggerFactory.getLogger(CipherServiceImpl.class);
    private final Updater updater;
    private final Fetcher fetcher;
    private static final String KEY_ALGORITHM = "AES";

    public CipherServiceImpl(Updater updater, Fetcher fetcher) {
        this.updater = updater;
        this.fetcher = fetcher;
    }

    @Override
    public String aesEncrypt(String content, String key) {
        try {
            return CipherServiceImpl.encrypt(content, key);
        }
        catch (Exception e) {
            log.warn("encrypt: ", (Throwable)e);
            return null;
        }
    }

    @Override
    public String aesDecrypt(String encrypt, String key) {
        try {
            return CipherServiceImpl.decrypt(encrypt, key);
        }
        catch (Exception e) {
            log.warn("decrypt: ", (Throwable)e);
            return null;
        }
    }

    @Override
    public String generateRequestId(String key) {
        String requestId = UUIDHelper.generate();
        this.updater.update(CipherServiceImpl.getRequestId2Key(requestId), (Object)key, 600);
        return requestId;
    }

    @Override
    public String getKey(String requestId) {
        return (String)this.fetcher.fetch(CipherServiceImpl.getRequestId2Key(requestId), String.class);
    }

    private static KeyGenerator getRequestId2Key(String requestId) {
        return () -> KeyBuilder.build((Object[])new Object[]{"ADX", "TMP", "REQUESTID2KEY", requestId});
    }

    private static String encrypt(String content, String key) throws Exception {
        if (StringUtils.isBlank((CharSequence)content) || StringUtils.isBlank((CharSequence)key)) {
            return null;
        }
        Cipher cipher = Cipher.getInstance(KEY_ALGORITHM);
        byte[] byteContent = content.getBytes(StandardCharsets.UTF_8);
        SecretKeySpec sKey = new SecretKeySpec(key.getBytes(), KEY_ALGORITHM);
        cipher.init(1, sKey);
        byte[] result = cipher.doFinal(byteContent);
        return Base64.encodeBase64String((byte[])result);
    }

    private static String decrypt(String encryptContent, String key) throws Exception {
        byte[] content = Base64.decodeBase64((String)encryptContent);
        if (content == null) {
            return null;
        }
        SecretKeySpec sKey = new SecretKeySpec(key.getBytes(), KEY_ALGORITHM);
        Cipher cipher = Cipher.getInstance(KEY_ALGORITHM);
        cipher.init(2, sKey);
        byte[] result = cipher.doFinal(content);
        return new String(result);
    }
}

