/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adx.common.filter;

import com.bxm.adx.common.filter.AbstractPositionFilter;
import com.bxm.adx.common.market.MarketOrders;
import com.bxm.adx.common.sell.position.Position;
import com.bxm.mcssp.common.enums.position.PositionSceneTypeEnum;
import com.bxm.warcar.cache.Counter;
import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.utils.KeyBuilder;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PositionPushReqIntervalTimesFilter
extends AbstractPositionFilter {
    private static final Logger log = LoggerFactory.getLogger(PositionPushReqIntervalTimesFilter.class);
    @Autowired
    private Counter counter;

    @Override
    protected List<String> doFilter(MarketOrders marketOrders) {
        List<Position> positions = marketOrders.getPositions();
        if (CollectionUtils.isEmpty(positions)) {
            return null;
        }
        ArrayList list = Lists.newArrayList();
        positions.forEach(position -> {
            KeyGenerator key;
            Byte pScene = position.getPositionScene();
            if (pScene == null) {
                return;
            }
            PositionSceneTypeEnum typeEnum = PositionSceneTypeEnum.get((Integer)pScene.intValue());
            if (typeEnum == null) {
                return;
            }
            if (typeEnum == PositionSceneTypeEnum.PUSH && this.isLimitRequest(key = () -> KeyBuilder.build((Object[])new Object[]{"tmp", "adx", "push", "limit", position.getPositionId(), marketOrders.getUid()}))) {
                list.add(position.getPositionId());
            }
        });
        return list;
    }

    @Override
    public int order() {
        return 2;
    }

    private boolean isLimitRequest(KeyGenerator key) {
        return this.counter.incrementAndGet(key, 10) > 1L;
    }
}

