/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adx.common.filter;

import com.bxm.adx.common.adapter.AdxContextFactory;
import com.bxm.adx.common.filter.AbstractPositionFilter;
import com.bxm.adx.common.ip.IpService;
import com.bxm.adx.common.market.MarketOrders;
import com.bxm.adx.common.sell.BidRequest;
import com.bxm.adx.common.sell.position.Position;
import com.bxm.adx.common.sell.request.Device;
import com.bxm.warcar.ip.IP;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class PositionRegionLimiterFilter
extends AbstractPositionFilter {
    private static final Logger log = LoggerFactory.getLogger(PositionRegionLimiterFilter.class);
    private final IpService ipService;

    public PositionRegionLimiterFilter(IpService ipService) {
        this.ipService = ipService;
    }

    @Override
    protected List<String> doFilter(MarketOrders marketOrders) {
        List<Position> positions = marketOrders.getPositions();
        if (CollectionUtils.isEmpty(positions)) {
            return null;
        }
        ArrayList list = Lists.newArrayList();
        IP ipp = this.getIp(marketOrders.getBidRequest());
        positions.forEach(position -> {
            String regionCodes = position.getRegion();
            if (StringUtils.isEmpty((Object)regionCodes)) {
                return;
            }
            HashSet set = Sets.newHashSet();
            set.addAll(Arrays.asList(regionCodes.split(",")));
            if (Objects.nonNull(ipp) && ipp.in((Set)set)) {
                return;
            }
            list.add(position.getPositionId());
        });
        return list;
    }

    private IP getIp(BidRequest bidRequest) {
        String ip;
        Device device;
        IP ipp = null;
        if (bidRequest != null && (device = bidRequest.getDevice()) != null && !StringUtils.isEmpty((Object)(ip = device.getIp()))) {
            ipp = this.ipService.analyze(ip);
            AdxContextFactory.get().setIp(ipp);
        }
        return ipp;
    }

    @Override
    public int order() {
        return 3;
    }
}

