/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adx.common.market.exchange;

import com.bxm.adx.common.AdxProperties;
import com.bxm.adx.common.CacheKeys;
import com.bxm.adx.common.buy.buyers.BuyerWrapper;
import com.bxm.adx.common.buy.dsp.Dsp;
import com.bxm.adx.common.ingetration.AdxCounterServiceIntegration;
import com.bxm.adx.common.market.Deal;
import com.bxm.adx.common.market.exchange.ExchangeCallable;
import com.bxm.adx.common.market.exchange.ExchangeParam;
import com.bxm.adx.common.market.exchange.Exchanger;
import com.bxm.adx.common.micrometer.BuyerMeter;
import com.bxm.adx.common.sell.BidRequest;
import com.bxm.warcar.cache.Counter;
import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.integration.eventbus.EventPark;
import com.bxm.warcar.utils.NamedThreadFactory;
import com.google.common.collect.Lists;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Configuration;

@Configuration
public class RtbExchanger
implements Exchanger {
    private static final Logger log = LoggerFactory.getLogger(RtbExchanger.class);
    private final AdxProperties properties;
    private final AdxCounterServiceIntegration service;
    private final BuyerMeter buyerMeter;
    private final Counter counter;
    private final EventPark eventPark;

    public RtbExchanger(AdxProperties properties, AdxCounterServiceIntegration service, BuyerMeter buyerMeter, Counter counter, EventPark eventPark) {
        this.properties = properties;
        this.service = service;
        this.buyerMeter = buyerMeter;
        this.counter = counter;
        this.eventPark = eventPark;
    }

    @Override
    public List<Deal> bidding(BidRequest bidRequest, Collection<BuyerWrapper> buyers) {
        int size = buyers.size();
        if (0 == size) {
            return Collections.emptyList();
        }
        if (null == bidRequest) {
            return Collections.emptyList();
        }
        ThreadPoolExecutor executor = new ThreadPoolExecutor(size, size, 5L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)new NamedThreadFactory("exchange"));
        executor.allowCoreThreadTimeOut(true);
        ArrayList futures = Lists.newArrayListWithCapacity((int)size);
        for (BuyerWrapper buyer : buyers) {
            if (!this.dspQPSLimit(buyer.getBuyer().getDsp())) continue;
            ExchangeParam exchangeParam = new ExchangeParam();
            exchangeParam.setDispatcher(buyer.getDispatcher());
            Future<Deal> future = executor.submit(new ExchangeCallable(buyer.getBuyer(), bidRequest, this.service, this.buyerMeter, exchangeParam, this.eventPark));
            futures.add(future);
        }
        ArrayList deals = Lists.newArrayList();
        for (Future future : futures) {
            try {
                Deal response = (Deal)future.get();
                if (null == response) continue;
                deals.add(response);
            }
            catch (InterruptedException | ExecutionException e) {
                future.cancel(true);
                log.error("execute: ", (Throwable)e);
            }
        }
        return deals;
    }

    private boolean dspQPSLimit(Dsp dsp) {
        if (dsp == null) {
            return false;
        }
        Integer qps = dsp.getQps();
        if (qps == null) {
            return true;
        }
        if (qps < 0) {
            return true;
        }
        if (qps == 0) {
            return false;
        }
        long time = LocalDateTime.now().toEpochSecond(ZoneOffset.of("+8"));
        KeyGenerator keyGenerator = CacheKeys.getDspNowQPS(time + "");
        Long now = this.counter.hincrementAndGet(keyGenerator, dsp.getDspCode(), 600);
        return now <= (long)qps.intValue();
    }
}

