/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adx.common.market.filter;

import com.bxm.adx.common.buy.Buyer;
import com.bxm.adx.common.creative.CreativeService;
import com.bxm.adx.common.market.Deal;
import com.bxm.adx.common.market.filter.Filter;
import com.bxm.adx.common.sell.BidResponse;
import com.bxm.adx.common.sell.response.Bid;
import com.bxm.adx.common.sell.response.SeatBid;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;

@Order(value=-2147483648)
@Configuration
public class CreativeFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(CreativeFilter.class);
    private final CreativeService creativeService;

    public CreativeFilter(CreativeService creativeService) {
        this.creativeService = creativeService;
    }

    @Override
    public void filter(List<Deal> deals) {
        deals.removeIf(deal -> {
            BidResponse response = deal.getBidResponse();
            if (null == response) {
                if (log.isDebugEnabled()) {
                    log.debug("response is null");
                }
                return true;
            }
            Buyer buyer = deal.getBuyer();
            Long dspId = buyer.getDsp().getId();
            List<SeatBid> seatBidList = response.getSeat_bid();
            if (CollectionUtils.isEmpty(seatBidList)) {
                if (log.isDebugEnabled()) {
                    log.debug("response seatbids is null");
                }
                return true;
            }
            seatBidList.removeIf(seatBid -> {
                List<Bid> bids = seatBid.getBid();
                if (CollectionUtils.isEmpty(bids)) {
                    if (log.isDebugEnabled()) {
                        log.debug("response bids is null");
                    }
                    return true;
                }
                bids.removeIf(bid -> {
                    String tag_id = bid.getTag_id();
                    return !this.creativeService.isEnabled(tag_id, dspId, bid.getCreate_id());
                });
                return CollectionUtils.isEmpty(bids);
            });
            return CollectionUtils.isEmpty(seatBidList);
        });
    }

    public int getOrder() {
        return 0x7FFFFFFE;
    }
}

