/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adx.common.market.filter;

import com.bxm.adx.common.adapter.AdxContextFactory;
import com.bxm.adx.common.market.Deal;
import com.bxm.adx.common.market.filter.Filter;
import com.bxm.adx.common.sell.BidResponse;
import com.bxm.adx.common.sell.response.Bid;
import com.bxm.adx.common.sell.response.ImpMonitor;
import com.bxm.adx.common.sell.response.SeatBid;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Configuration;

@Configuration
public class OptimizationFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(OptimizationFilter.class);

    @Override
    public void filter(List<Deal> deals) {
        if (AdxContextFactory.get().isOptimization()) {
            deals.removeIf(deal -> {
                String code = deal.getBuyer().getCode();
                if ("optimization".equalsIgnoreCase(code)) {
                    BidResponse bidResponse = deal.getBidResponse();
                    if (Objects.nonNull(bidResponse)) {
                        List bids = bidResponse.getSeat_bid().stream().map(SeatBid::getBid).flatMap(Collection::stream).collect(Collectors.toList());
                        for (Bid bid : bids) {
                            if (!Objects.nonNull(bid)) continue;
                            List<String> urls = bid.getImp_monitors().stream().map(ImpMonitor::getImp_monitor_url).collect(Collectors.toList());
                            AdxContextFactory.get().setOptimizationImpUrls(urls);
                            break;
                        }
                    }
                    return true;
                }
                return false;
            });
        }
    }

    public int getOrder() {
        return Integer.MIN_VALUE;
    }
}

