package com.bxm.adx.common.buy.position;

import com.bxm.warcar.cache.Fetcher;
import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.cache.Updater;
import com.bxm.warcar.cache.push.Pushable;
import com.bxm.warcar.integration.pushable.annotation.CachePush;
import com.bxm.warcar.utils.JsonHelper;
import com.bxm.warcar.utils.KeyBuilder;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import java.util.Map;
import java.util.Objects;

/**
 * @author fgf
 * @date 2022/7/15
 **/
@CachePush("ADVERT_POINT")
@Component
@Slf4j
public class AdvertPointDaoImpl implements AdvertPointDao, Pushable {
    private final Fetcher fetcher;
    private final Updater updater;

    public AdvertPointDaoImpl(Fetcher fetcher, Updater updater) {
        this.fetcher = fetcher;
        this.updater = updater;
    }

    @Override
    public void push(Map<String, Object> parameters, byte[] data) {
        if (log.isWarnEnabled()) {
            log.warn("advert point data = {}", JsonHelper.convert(data, String.class));
        }

        AdvertPoint advertPoint = JsonHelper.convert(data, AdvertPoint.class);
        if (checkData(advertPoint)) {
            return;
        }

        KeyGenerator keyGenerator = getKeyGenerator(advertPoint.getAppId(), advertPoint.getPositionId());
        updater.remove(keyGenerator);
        if (Objects.nonNull(advertPoint.getDeleted()) && advertPoint.getDeleted() == 0) {
            updater.update(keyGenerator, advertPoint);
        }
    }

    private KeyGenerator getKeyGenerator(String dspAppId, String dspPositionId) {
        return () -> KeyBuilder.build("ADX", "ADVERT_POINT", dspAppId, dspPositionId);
    }

    /**
     * 校验数据正确性
     * 非法数据返回true
     * @param advertPoint
     * @return
     */
    private boolean checkData(AdvertPoint advertPoint) {
        if (Objects.isNull(advertPoint)) {
            return true;
        }
        if (Objects.isNull(advertPoint.getAppId()) || Objects.isNull(advertPoint.getPositionId())) {
            return true;
        }
        if (Objects.isNull(advertPoint.getDeleted())) {
            return true;
        }
        return false;
    }

    @Override
    public AdvertPoint getAdvertPoint(String dspAppId, String dspPositionId) {
        return fetcher.fetch(getKeyGenerator(dspAppId, dspPositionId), AdvertPoint.class);
    }
}
