/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adx.common.buy.dsp;

import com.bxm.adx.common.buy.dsp.Dsp;
import com.bxm.adx.common.buy.dsp.DspChangedEvent;
import com.bxm.adx.common.buy.dsp.DspDao;
import com.bxm.warcar.cache.Fetcher;
import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.cache.Updater;
import com.bxm.warcar.cache.push.Pushable;
import com.bxm.warcar.integration.pushable.annotation.CachePush;
import com.bxm.warcar.utils.JsonHelper;
import com.bxm.warcar.utils.KeyBuilder;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEvent;
import org.springframework.stereotype.Component;

@CachePush(value="DSP")
@Component
public class DspDaoImpl
implements DspDao,
Pushable,
ApplicationContextAware {
    private static final Logger log = LoggerFactory.getLogger(DspDaoImpl.class);
    private final Fetcher fetcher;
    private final Updater updater;
    private ApplicationContext applicationContext;

    public DspDaoImpl(Fetcher fetcher, Updater updater) {
        this.fetcher = fetcher;
        this.updater = updater;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    @Override
    public Collection<Dsp> getAll() {
        return this.fetcher.hfetchall(this.getKeyGenerator(), Dsp.class).values();
    }

    public void push(Map<String, Object> parameters, byte[] data) {
        if (log.isDebugEnabled()) {
            log.debug("dsp = {}", (Object)new String(data));
        }
        Dsp dsp = (Dsp)JsonHelper.convert((byte[])data, Dsp.class);
        Long id = dsp.getId();
        this.updater.hremove(this.getKeyGenerator(), new String[]{Objects.toString(id)});
        if (!dsp.isForbidden()) {
            this.updater.hupdate(this.getKeyGenerator(), Objects.toString(id), (Object)dsp);
        }
        this.applicationContext.publishEvent((ApplicationEvent)new DspChangedEvent(this, dsp));
    }

    private KeyGenerator getKeyGenerator() {
        return () -> KeyBuilder.build((Object[])new Object[]{"ADX", "DSPS"});
    }
}

