package com.bxm.adx.common;

import org.apache.http.client.config.CookieSpecs;
import org.springframework.boot.context.properties.ConfigurationProperties;

import lombok.Data;

/**
 * @author allen
 * @since 2019-12-12
 */
@Data
@ConfigurationProperties(prefix = "adx")
public class AdxProperties {

    /**
     * 买方竞价超时时间，单位：毫秒。默认：100
     */
    @Deprecated
    private int buyerBiddingTimeOutInMillis = 1000;

    /**
     * 并发买方竞价超时时间，单位：毫秒。默认：200
     */
    @Deprecated
    private int buyerConcurrentBiddingTimeOutInMillis = 200;

    /**
     * 买方请求连接超时时间，单位：毫秒。默认：100
     */
    private int buyerBiddingConnectTimeOutInMillis = 100;

    /**
     * 买方请求读取结果超时时间，单位：毫秒。默认：300
     */
    private int buyerBiddingSocketTimeOutInMillis = 300;

    /**
     * 买方请求连接池 DefaultMaxPerRoute
     */
    private int buyerDefaultMaxPerRoute = 100;

    /**
     * 买方请求连接池 MaxTotal
     */
    private int buyerMaxTotal = 200;

    /**
     * 统计接口地址
     */
    private String counterBaseUrl = "http://count.hzbxm.com/adx/dot/countInfo";

    /**
     * <p>最大买家队列容量，默认 5级。</p>
     * <p>流量分配时，分发优先级数量最不超过这个值。</p>
     */
    private int maxCapacityOfBuyers = 5;

    /**
     * 买方响应 Cookie 策略。
     * 可选值：default、standard、ignoreCookies 等
     * @see CookieSpecs
     */
    private String buyerCookieSpec = "standard";

    /**
     * OpenLog 服务相关配置
     */
    private OpenLogProperties openLog = new OpenLogProperties();

    /**
     * 价格加解密key配置
     */
    private CipherProperties cipherProperties = new CipherProperties();

    /**
     * 当开启请求事件或竞价事件监听器时，采样的百分比设置。
     */
    private int dotSimplingPercent = 1;

}
