package com.bxm.adx.common.buy;

import com.bxm.adx.common.adapter.BuyModelAdapter;
import com.bxm.adx.common.buy.dsp.Dsp;
import com.bxm.adx.common.sell.BidRequest;

/**
 * 购买流量
 *
 * @author allen
 * @since 2019-12-12
 */
public interface Buyer {

    /**
     * 返回当前买家
     *
     * @return DSP
     */
    Dsp getDsp();

    /**
     * 买方名称，需要唯一。(平台唯一标识)
     *
     * @return 名称
     * @see Dsp#getDspCode()
     */
    String getCode();

    /**
     * 返回这个买家的模型适配器
     *
     * @return 模型适配器
     */
    BuyModelAdapter getModelAdapter();

    /**
     * <p>出价</p>
     * <p>这方法的请求、返回字节数组都会通过 {@link BuyModelAdapter} 构建成系统所需对象。</p>
     * <p>你可以实现该接口中 {@link #getModelAdapter()} 的方法来指定 {@link BuyModelAdapter} 的实现。</p>
     * @param request 请求字节数组，
     *                它是通过 {@link BuyModelAdapter#buildRequest(BidRequest)} 处理得到的数据。
     *
     * @return 出价结果字节数组，根据买方的协议构成。
     * 出价完成后，系统会调用 {@link BuyModelAdapter#buildResponse(byte[])} 将结果字节数组构建成 {@link com.bxm.adx.common.sell.BidResponse} 对象返回给 {@link com.bxm.adx.common.market.exchange.Exchanger}。
     * @see com.bxm.adx.common.market.exchange.Exchanger
     * @see com.bxm.adx.common.market.exchange.RtbExchanger
     */
    byte[] offer(byte[] request);
}
