/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adx.common;

import com.bxm.adx.common.PositionSceneTypeEnum;
import java.lang.invoke.LambdaMetafactory;
import java.util.Arrays;
import java.util.Objects;
import java.util.function.Predicate;
import org.apache.commons.lang.StringUtils;

public class AdxConstants {
    public static final Integer RESULT_OK = 0;
    public static final byte YES = 1;
    public static final byte NO = 0;
    public static final int ADX_REQ = 15001;
    public static final int ADX_RESP = 15104;
    public static final int DSP_REQ = 15002;
    public static final int DSP_RESP = 15103;
    public static final String PUSH_POSITION_VERSION = "3.5.9";
    public static final String SDK_ERR_CODE_VERSION = "3.7.0";
    public static final Long SDK_WAIT_TIME = 450L;
    public static final Long API_WAIT_TIME = 350L;
    public static final Long SDK_OVER_TIME = 500L;
    public static final Long API_OVER_TIME = 400L;

    public static boolean needReplacePrice(String mediaId) {
        if (StringUtils.isNotEmpty((String)mediaId)) {
            Media media = Media.of(Integer.parseInt(mediaId));
            switch (media) {
                case Julang: 
                case Baisou: 
                case Moliguo: 
                case Woke: 
                case Kingstone: 
                case Tairan: 
                case Zixuan: 
                case Puliang: 
                case Xinbianjie: {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    public static interface DockingMethodType {
        public static final int API = 1;
        public static final int SDK = 2;
    }

    public static enum SettleType {
        DIVIDE_INTO(1, "\u5206\u6210"),
        RTB(2, "\u56fa\u4ef7"),
        REAL_TIME_RTB(3, "\u5b9e\u65f6\u7ade\u4ef7");

        private Integer type;
        private String name;

        private SettleType(Integer type, String name) {
            this.type = type;
            this.name = name;
        }

        public Integer getType() {
            return this.type;
        }

        public String getName() {
            return this.name;
        }

        public static SettleType get(Integer type) {
            if (null == type) {
                return null;
            }
            for (SettleType anEnum : SettleType.values()) {
                if (!anEnum.getType().equals(type)) continue;
                return anEnum;
            }
            return null;
        }
    }

    public static interface BidModel {
        public static final int CPM = 1;
        public static final int CPC = 2;
    }

    public static enum Media {
        Unknown(0),
        Bxm(1),
        Bxmssp(2),
        Backup(3),
        Julang(4),
        Paradigm(5),
        Meishu(6),
        Wps(7),
        Jishubao(8),
        Baisou(9),
        Manxing(10),
        Guangyin(11),
        Liandao(12),
        Ssp2345(13),
        Bochuang(14),
        Xiaomai(15),
        Yien(16),
        Jugao(17),
        Yiqi(18),
        Jumai(19),
        Chuwang(20),
        Moliguo(21),
        Woke(22),
        Kingstone(23),
        Jialiang(24),
        Shengtong(25),
        Tairan(26),
        Yixuan(27),
        Zixuan(28),
        Puliang(29),
        Yidao(30),
        Kuaiya(31),
        Inmobi(32),
        Xinbianjie(33),
        Xinzhi(34),
        Zhongqing(35),
        Wanwei(36),
        Sigmob(37),
        Shuchuan(38),
        Soul(39);

        private final int id;

        private Media(int id) {
            this.id = id;
        }

        public static Media of(int id) {
            Media[] values;
            for (Media value : values = Media.values()) {
                if (id != value.id) continue;
                return value;
            }
            return Unknown;
        }

        public int getId() {
            return this.id;
        }
    }

    public static enum Imsi {
        MOBILE("46000"),
        UNICOM("46001"),
        TELECOM("46003");

        private String imsi;

        private Imsi(String imsi) {
            this.imsi = imsi;
        }

        public String getImsi() {
            return this.imsi;
        }
    }

    public static enum AssetType {
        UNKNOW(0),
        TITLE(1),
        CONTENT(2),
        BTN_TEXT(3),
        BTN_CONTENT(4),
        PRICE(5),
        ICON(6),
        LARGE_IMG(7),
        BTN_IMG(8),
        DESC(9),
        RATING(10),
        VIDEO(11),
        REWARDER_VIDEO(12),
        POPUP_ASSET_INFO(16),
        POPUP_WEB_URL(17);

        private Integer type;

        private AssetType(Integer type) {
            this.type = type;
        }

        public Integer getType() {
            return this.type;
        }

        public static AssetType getAssetType(Integer type) {
            if (type == null) {
                return UNKNOW;
            }
            return Arrays.stream(AssetType.values()).filter(at -> at.type.equals(type)).findFirst().orElse(UNKNOW);
        }
    }

    public static enum Macro {
        __X_DOWN__,
        __Y_DOWN__,
        __X_UP__,
        __Y_UP__,
        __REQPW__,
        __REQPH__,
        __ACTPW__,
        __ACTPH__,
        __VI_DURATION__,
        __STATUS__;

    }

    public static enum Carrier {
        MOBILE(0),
        TELECOM(1),
        UNICOM(3),
        UNKNOW(4);

        public Integer carrier;

        private Carrier(Integer carrier) {
            this.carrier = carrier;
        }

        public static Carrier getCarrier(Integer carrier) {
            if (carrier == null) {
                return UNKNOW;
            }
            return Arrays.stream(Carrier.values()).filter(carrier1 -> carrier1.carrier.equals(carrier)).findFirst().orElse(UNKNOW);
        }
    }

    public static enum ConnectionType {
        UNKNOW(0, "unknow"),
        WIFI(1, "wifi"),
        UNKNOW_XG(2, "xg"),
        _2G(3, "2g"),
        _3G(4, "3g"),
        _4G(5, "4g"),
        _5G(6, "5g"),
        ETHERNET(7, "ethernet");

        private Integer type;
        private String network;

        private ConnectionType(Integer type, String network) {
            this.type = type;
            this.network = network;
        }

        public Integer getType() {
            return this.type;
        }

        public String getNetwork() {
            return this.network;
        }

        public static Integer getType(String typeStr) {
            if (StringUtils.isEmpty((String)typeStr)) {
                return ConnectionType.UNKNOW.type;
            }
            return Arrays.stream(ConnectionType.values()).filter((Predicate<ConnectionType>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$getType$0(java.lang.String com.bxm.adx.common.AdxConstants$ConnectionType ), (Lcom/bxm/adx/common/AdxConstants$ConnectionType;)Z)((String)typeStr)).findFirst().orElse((ConnectionType)ConnectionType.UNKNOW).type;
        }

        public static ConnectionType getType(Integer type) {
            if (type == null) {
                return UNKNOW;
            }
            return Arrays.stream(ConnectionType.values()).filter(connectionType -> connectionType.type.equals(type)).findFirst().orElse(UNKNOW);
        }

        public static ConnectionType getType(Integer type, String os) {
            if (type == null) {
                return UNKNOW;
            }
            if (StringUtils.isEmpty((String)os)) {
                return UNKNOW;
            }
            if (!"ios".equalsIgnoreCase(os)) {
                return UNKNOW;
            }
            switch (type) {
                case 1: {
                    return WIFI;
                }
                case 2: {
                    return _2G;
                }
                case 3: {
                    return _3G;
                }
                case 4: {
                    return _4G;
                }
            }
            return UNKNOW;
        }

        private static /* synthetic */ boolean lambda$getType$0(String typeStr, ConnectionType connectionType) {
            return connectionType.network.equalsIgnoreCase(typeStr);
        }
    }

    public static enum CounterMt {
        IMP("1"),
        CLICK("2"),
        V_START("3"),
        V_1_4("4"),
        V_1_2("5"),
        V_3_4("6"),
        V_END("7"),
        V_MUTE("8"),
        V_SKIP("9"),
        V_CLOSED("10"),
        V_SUSPEND("11"),
        V_PROCEED("12"),
        V_BAD_NET("18"),
        V_FULL_SCREEN_PLAY("19"),
        V_CLOSE_FULL_SCREEN_PLAY("20"),
        V_CLOSE_MUTE_PLAY("21"),
        V_LEAVE("26"),
        V_ABANDON("29"),
        APP_D_START("13"),
        APP_D_END("14"),
        APP_IN_START("15"),
        APP_IN_END("16"),
        APP_ACT("22"),
        DP_START("23"),
        DP_SUCCESS("24"),
        DP_FAIL("25"),
        IMP_FAIL("27"),
        CLICK_FAIL("28");

        private String mt;

        private CounterMt(String mt) {
            this.mt = mt;
        }

        public String getMt() {
            return this.mt;
        }
    }

    public static enum ActivityErr {
        DOUDI,
        MEI_DOU_ZHU;

    }

    public static enum Action {
        UNKNOW(0),
        DOWNLOAD_ANDROID(2),
        DOWNLOAD_IOS(3),
        WEB_VIEW(6),
        DEEP_LINK(9),
        DEEP_LINK_DOWNLOAD(11),
        INSPIRE_BROWSE(12),
        DOWNLOAD(13);

        public int action;

        private Action(int action) {
            this.action = action;
        }

        public int getAction() {
            return this.action;
        }

        public static boolean isAppDownload(Integer action) {
            if (action == null) {
                return false;
            }
            Action act = Arrays.stream(Action.values()).filter(a -> a.getAction() == action.intValue()).findFirst().orElse(UNKNOW);
            return act == DOWNLOAD_ANDROID || act == DOWNLOAD_IOS || act == DEEP_LINK_DOWNLOAD;
        }

        public static Action getAction(Integer action) {
            if (Objects.isNull(action)) {
                return UNKNOW;
            }
            return Arrays.stream(Action.values()).filter(a -> a.action == action).findFirst().orElse(UNKNOW);
        }
    }

    public static enum Type {
        NATIVE(1),
        IMAGE(2),
        VIDEO(3),
        TEXT(4),
        INSPIRE_VIDEO(5),
        ANIMATION_POPUP(6);

        private Integer type;

        private Type(Integer type) {
            this.type = type;
        }

        public Integer getType() {
            return this.type;
        }

        public static Integer getTypeByPositionScene(Byte scene) {
            PositionSceneTypeEnum sceneTypeEnum = PositionSceneTypeEnum.get(scene.intValue());
            if (sceneTypeEnum == null) {
                return null;
            }
            switch (sceneTypeEnum) {
                case INFORMATION_FLOW: {
                    return NATIVE.getType();
                }
                case BOOT: {
                    return IMAGE.getType();
                }
                case SCREEN: {
                    return IMAGE.getType();
                }
                case BUTTON: {
                    return IMAGE.getType();
                }
                case INFORMATION_FLOW_SELF_RENDERING: {
                    return NATIVE.getType();
                }
                case BANNER: {
                    return IMAGE.getType();
                }
                case ICON: {
                    return IMAGE.getType();
                }
                case VIDEO: {
                    return VIDEO.getType();
                }
                case INSPIRE_VIDEO: {
                    return INSPIRE_VIDEO.getType();
                }
                case SELF_RENDERING: {
                    return NATIVE.getType();
                }
                case INFORMATION_FLOW_IMMERSIVE_VIDEO: {
                    return VIDEO.getType();
                }
                case TAB_PAGE: {
                    return NATIVE.getType();
                }
                case PUSH: {
                    return NATIVE.getType();
                }
            }
            return null;
        }
    }

    public static interface RequestModel {
        public static final int TIMING = 1;
        public static final int DRIVING = 2;
    }
}

