/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adx.common.sell;

import com.bxm.adx.common.AdxConstants;
import com.bxm.adx.common.AdxProperties;
import com.bxm.adx.common.adapter.AdxContextFactory;
import com.bxm.adx.common.buy.Buyer;
import com.bxm.adx.common.buy.buyers.BuyerWrapper;
import com.bxm.adx.common.buy.buyers.PriorityBuyers;
import com.bxm.adx.common.buy.dispatcher.Dispatcher;
import com.bxm.adx.common.buy.optimization.Optimization;
import com.bxm.adx.common.buy.optimization.OptimizationDao;
import com.bxm.adx.common.ip.IpService;
import com.bxm.adx.common.market.MarketOrders;
import com.bxm.adx.common.market.MarketRequest;
import com.bxm.adx.common.openlog.event.internal.MediaRequestEvent;
import com.bxm.adx.common.sell.BidConfig;
import com.bxm.adx.common.sell.BidRequest;
import com.bxm.adx.common.sell.BidRequestWrapper;
import com.bxm.adx.common.sell.position.Position;
import com.bxm.adx.common.sell.position.PositionService;
import com.bxm.adx.common.sell.request.Device;
import com.bxm.adx.common.sell.request.Impression;
import com.bxm.adx.facade.constant.enums.AdxErrEnum;
import com.bxm.adx.facade.exception.AdxException;
import com.bxm.user.id.generator.DeviceHelper;
import com.bxm.user.id.generator.DeviceInfo;
import com.bxm.warcar.integration.eventbus.EventPark;
import com.bxm.warcar.ip.IP;
import com.bxm.warcar.utils.JsonHelper;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.RandomStringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.CollectionUtils;

@Configuration
public class DefaultBidRequestWrapper
implements BidRequestWrapper {
    private static final Logger log = LoggerFactory.getLogger(DefaultBidRequestWrapper.class);
    private final PriorityBuyers priorityBuyers;
    private final PositionService positionService;
    private final AdxProperties properties;
    private final OptimizationDao optimizationDao;
    private final IpService ipService;
    private final EventPark eventPark;

    public DefaultBidRequestWrapper(PriorityBuyers priorityBuyers, PositionService positionService, AdxProperties properties, OptimizationDao optimizationDao, IpService ipService, EventPark eventPark) {
        this.priorityBuyers = priorityBuyers;
        this.positionService = positionService;
        this.properties = properties;
        this.optimizationDao = optimizationDao;
        this.ipService = ipService;
        this.eventPark = eventPark;
    }

    @Override
    public MarketOrders packing(BidRequest bidRequest) {
        Position position;
        if (null == bidRequest) {
            return null;
        }
        if (Objects.isNull(bidRequest.getId())) {
            bidRequest.setId(RandomStringUtils.randomAlphabetic((int)10));
        }
        AdxContextFactory.get().setBidRequest(bidRequest);
        BidConfig bidConfig = new BidConfig().setDisDot(Math.abs(bidRequest.getId().hashCode() % 100) >= this.properties.getDotSimplingPercent());
        AdxContextFactory.get().setBidConfig(bidConfig);
        List<Impression> imps = bidRequest.getImps();
        if (CollectionUtils.isEmpty(imps)) {
            throw new AdxException(AdxErrEnum.POSITION_NOT_FOUND);
        }
        HashMap positionListMap = Maps.newHashMap();
        ArrayList<Position> positionList = new ArrayList<Position>();
        for (Impression impression : imps) {
            String string = impression.getTag_id();
            if (StringUtils.isBlank((String)string)) continue;
            position = this.positionService.getByPositionId(string);
            if (null != position) {
                AdxContextFactory.get().setPosition(position);
                impression.setTag_id(position.getPositionId());
                positionList.add(position);
                bidRequest.setCooperationType(position.getCooperationType());
                Integer dockingMethodType = position.getDockingMethodType();
                bidRequest.setDockingMethodType(dockingMethodType);
                bidRequest.setBxmTagId(position.getPositionId());
                Long waitTime = position.getWaitTime();
                Long overTime = position.getOvertime();
                if (Objects.nonNull(dockingMethodType)) {
                    if (Objects.isNull(waitTime)) {
                        waitTime = dockingMethodType == 1 ? AdxConstants.API_WAIT_TIME : AdxConstants.SDK_WAIT_TIME;
                    }
                    if (Objects.isNull(overTime)) {
                        overTime = dockingMethodType == 1 ? AdxConstants.API_OVER_TIME : AdxConstants.SDK_OVER_TIME;
                    }
                } else {
                    waitTime = 0L;
                    overTime = 0L;
                }
                bidRequest.setWaitTime(waitTime);
                bidRequest.setOvertime(overTime);
            }
            if (null == position || !position.isEnabled()) continue;
            List<List<BuyerWrapper>> buyers = this.priorityBuyers.findAsPriority(position, impression.getBid_floor(), impression.getBid_top());
            this.handleOptimization(position, bidRequest, buyers);
            this.handleBackupEntrance(bidRequest, buyers);
            positionListMap.put(position, buyers);
        }
        if (CollectionUtils.isEmpty((Map)positionListMap)) {
            throw new AdxException(AdxErrEnum.POSITION_NOT_FOUND);
        }
        this.eventPark.post((EventObject)new MediaRequestEvent(this, bidRequest, bidConfig));
        ArrayList requests = Lists.newArrayListWithCapacity((int)this.properties.getMaxCapacityOfBuyers());
        for (Map.Entry entry : positionListMap.entrySet()) {
            position = (Position)entry.getKey();
            List list = (List)entry.getValue();
            int level = list.size();
            if (level == 0) continue;
            for (int i = 0; i < level; ++i) {
                MarketRequest marketRequest;
                List array = (List)list.get(i);
                if (CollectionUtils.isEmpty((Collection)array)) continue;
                MarketRequest marketRequest2 = CollectionUtils.isEmpty((Collection)requests) ? null : (marketRequest = requests.size() > i ? (MarketRequest)requests.get(i) : null);
                if (null == marketRequest) {
                    marketRequest = new MarketRequest(i);
                    requests.add(i, marketRequest);
                }
                marketRequest.addBuyers(array);
                marketRequest.addPosition(position);
            }
        }
        MarketOrders marketOrders = new MarketOrders(bidRequest, requests, positionList, this.getUid(bidRequest));
        if (log.isDebugEnabled()) {
            log.debug("{}", (Object)JsonHelper.convert((Object)marketOrders));
        }
        return marketOrders;
    }

    private void handleBackupEntrance(BidRequest request, List<List<BuyerWrapper>> buyers) {
        String entanceName = request.getEntrance_name();
        if (StringUtils.isEmpty((String)entanceName)) {
            return;
        }
        if ("backup".equalsIgnoreCase(entanceName)) {
            buyers.clear();
            ArrayList<BuyerWrapper> buyerList = new ArrayList<BuyerWrapper>();
            buyers.add(buyerList);
            Map<String, Buyer> allBuyers = this.priorityBuyers.getAllBuyers();
            Buyer buyer = allBuyers.get("pangu-backup");
            if (buyer == null) {
                throw new AdxException("can't find backup-dsp ");
            }
            Dispatcher dispatcher = new Dispatcher();
            dispatcher.setDspBasePrice(BigDecimal.ZERO);
            dispatcher.setDspId(buyer.getDsp().getId());
            dispatcher.setDspAvgPrice(BigDecimal.ZERO);
            dispatcher.setProfitMargin(new BigDecimal(100));
            buyerList.add(new BuyerWrapper(buyer, dispatcher));
        }
    }

    private void handleOptimization(Position position, BidRequest request, List<List<BuyerWrapper>> buyers) {
        Map<String, Buyer> allBuyers;
        Buyer buyer;
        Optimization optimization = this.optimizationDao.getOptimizationByPositionId(position.getPositionId());
        if (Objects.isNull(optimization)) {
            return;
        }
        String regionCodes = optimization.getRegion();
        if (!org.springframework.util.StringUtils.isEmpty((Object)regionCodes)) {
            IP ipp = this.getIp(request);
            HashSet set = Sets.newHashSet();
            set.addAll(Arrays.asList(regionCodes.split(",")));
            if (Objects.isNull(ipp) || !ipp.in((Set)set)) {
                return;
            }
        }
        if ((buyer = (allBuyers = this.priorityBuyers.getAllBuyers()).get("optimization")) == null) {
            throw new AdxException("can't find op-dsp ");
        }
        Dispatcher dispatcher = new Dispatcher();
        dispatcher.setDspPosid(optimization.getDspPositionId());
        buyers.add(Lists.newArrayList((Object[])new BuyerWrapper[]{new BuyerWrapper(buyer, dispatcher)}));
        AdxContextFactory.get().setOptimization(true);
    }

    private String getUid(BidRequest bidRequest) {
        Device device = bidRequest.getDevice();
        if (device == null) {
            return null;
        }
        DeviceInfo info = new DeviceInfo().setImei(device.getImei()).setImeiMd5(device.getImei_md5()).setOaid(device.getOaid()).setOaidMd5(device.getOaid_md5()).setAnid(device.getDpid()).setAnidMd5(device.getDpid_md5()).setIdfa(device.getIdfa()).setIdfaMd5(device.getIdfa_md5()).setOs(device.isAndroid() ? 1 : (device.isIos() ? 2 : 0));
        return DeviceHelper.getUid((DeviceInfo)info);
    }

    private IP getIp(BidRequest bidRequest) {
        String ip;
        Device device;
        IP ipp = null;
        if (bidRequest != null && (device = bidRequest.getDevice()) != null && !org.springframework.util.StringUtils.isEmpty((Object)(ip = device.getIp()))) {
            ipp = this.ipService.analyze(ip);
            AdxContextFactory.get().setIp(ipp);
        }
        return ipp;
    }
}

