/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adx.common.sell.position;

import com.bxm.adx.common.sell.position.Position;
import com.bxm.adx.common.sell.position.PositionDao;
import com.bxm.adx.common.sell.position.PositionService;
import com.bxm.adx.common.sell.position.verify.AppVerify;
import com.bxm.adx.common.sell.position.verify.Context;
import com.bxm.adx.common.sell.position.verify.InnerPackageNameVerify;
import com.bxm.adx.common.sell.position.verify.SpecialAppIdVerify;
import com.bxm.adx.common.sell.ssp.SspRequest;
import com.bxm.adx.common.sell.ssp.req.App;
import com.bxm.mccms.facade.model.pushable.PositionInteractAppentranceRefCacheVO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.CommandLineRunner;
import org.springframework.context.annotation.Configuration;

@Configuration
public class PositionServiceImpl
implements PositionService,
CommandLineRunner {
    private static final Logger log = LoggerFactory.getLogger(PositionServiceImpl.class);
    private final PositionDao positionDao;
    private final SpecialAppIdVerify specialAppIdVerify;
    private final InnerPackageNameVerify innerPackageNameVerify;
    private final AppVerify appVerify;

    public PositionServiceImpl(PositionDao positionDao, SpecialAppIdVerify specialAppIdVerify, InnerPackageNameVerify innerPackageNameVerify, AppVerify appVerify) {
        this.positionDao = positionDao;
        this.specialAppIdVerify = specialAppIdVerify;
        this.innerPackageNameVerify = innerPackageNameVerify;
        this.appVerify = appVerify;
    }

    @Override
    public Position getByAppPositionId(String appPositionId) {
        return this.positionDao.getByAppPositionId(appPositionId);
    }

    @Override
    public Position getByPositionId(String positionId) {
        Position position = this.getByPositionIdNativeCache(positionId);
        if (position == null) {
            position = this.getByAppPositionIdNativeCache(positionId);
        }
        return position;
    }

    @Override
    public boolean verifyPosition(Position position, SspRequest sspRequest) {
        App app = sspRequest.getApp();
        if (app == null) {
            if (log.isWarnEnabled()) {
                log.warn("app is null");
            }
            return false;
        }
        Context context = new Context();
        context.setResult(false);
        context.setPosition(position);
        context.setAppId(app.getId());
        context.setPackageName(app.getBundle());
        context.setSdkVer(sspRequest.getVer());
        this.specialAppIdVerify.doVerify(context);
        return context.isResult();
    }

    @Override
    public boolean verifyPosition(Position position, String appId, String packageName, String sdkVer) {
        Context context = new Context();
        context.setResult(false);
        context.setPosition(position);
        context.setAppId(appId);
        context.setPackageName(packageName);
        context.setSdkVer(sdkVer);
        this.specialAppIdVerify.doVerify(context);
        return context.isResult();
    }

    @Override
    public PositionInteractAppentranceRefCacheVO getInteractByPositionId(String positionId) {
        return this.positionDao.getInteractByPositionId(positionId);
    }

    @Override
    public Position getByPositionIdNativeCache(String positionId) {
        return this.positionDao.getByPositionIdNativeCache(positionId);
    }

    @Override
    public Position getByAppPositionIdNativeCache(String appPositionId) {
        return this.positionDao.getByAppPositionIdNativeCache(appPositionId);
    }

    public void run(String ... args) throws Exception {
        this.specialAppIdVerify.setNextVerify(this.innerPackageNameVerify);
        this.innerPackageNameVerify.setNextVerify(this.appVerify);
    }
}

