package com.bxm.adx.common.adapter;

import com.bxm.adx.common.sell.BidConfig;
import com.bxm.adx.common.sell.BidRequest;
import com.bxm.adx.common.sell.position.Position;
import com.bxm.warcar.ip.IP;
import lombok.Data;
import lombok.experimental.Accessors;
import org.apache.commons.lang.StringUtils;
import org.springframework.http.MediaType;

import java.util.List;

/**
 * @author allen
 * @date 2020-09-25
 * @since 1.0
 */
@Data
@Accessors(chain = true)
public class AdxContext {

    public static final String CIPHER_TYPE_AES_RESPONSE = "1";

    private Object attachment;
    private String cipherType;
    private String uid;
    private Long configId;
    private IP ip;
    private boolean optimization = false;
    private List<String> optimizationImpUrls;
    /**
     * SDK并发竞价模式
     */
    private boolean isSDKConcurrentModel;
    private BidRequest bidRequest;
    private Position position;
    /**
     * 本次请求的系统配置
     */
    private BidConfig bidConfig;
    /**
     * 广告请求请求contentType
     */
    private MediaType mediaType;
    public boolean isCipherAesForResponse() {
        return StringUtils.equals(CIPHER_TYPE_AES_RESPONSE, cipherType);
    }
}
