package com.bxm.adx.common.adapter;

import com.bxm.adx.common.sell.BidRequest;
import com.bxm.adx.common.sell.BidResponse;
import com.bxm.adx.facade.constant.enums.AdxErrEnum;
import com.bxm.adx.facade.exception.AdxException;
import com.bxm.warcar.dpl2.plugin.PluginConfig;
import com.bxm.warcar.dpl2.plugin.PluginConfigAware;
import com.bxm.warcar.utils.JsonHelper;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang.math.NumberUtils;

/**
 * 配置式卖方插件，适合卖方对接BXM协议的情况
 * @author fgf
 * @date 2022/9/5
 **/
@Slf4j
public abstract class PluginConfigBidModelAdapter implements BidModelAdapter, PluginConfigAware {
    private PluginConfig pluginConfig;
    @Override
    public void setPluginConfig(PluginConfig pluginConfig) {
        this.pluginConfig = pluginConfig;
    }

    /**
     * 提供一种额外的获取mediaId的方式，旨在切断新媒体插件和Adx主项目的联系，media信息的维护可放在openlog相关文档里
     * @return
     */
    protected String getMediaId() {
        String mediaId = pluginConfig.getProperties().getProperty("id");
        if (NumberUtils.isNumber(mediaId)) {
            return mediaId;
        }
        throw new AdxException(AdxErrEnum.PLUGIN_ERR);
    }

    /**
     * 加密模式
     * @return
     */
    protected Integer getEncModel() {
        String model = pluginConfig.getProperties().getProperty("encModel");
        if (NumberUtils.isNumber(model)) {
            return Integer.valueOf(model);
        }
        return null;
    }

    @Override
    public BidRequest convert(byte[] bytes) {
        BidRequest bidRequest = JsonHelper.convert(bytes, BidRequest.class);
        bidRequest.setMediaId(getMediaId());
        bidRequest.setEncModel(getEncModel());
        return bidRequest;
    }

    @Override
    public byte[] convert(BidResponse e, BidRequest bidRequest) {
        return JsonHelper.convert2bytes(e);
    }
}
