package com.bxm.adx.common.buy.position;

import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import java.util.Objects;

/**
 * @author fgf
 * @date 2022/7/15
 **/
@Service
@Slf4j
public class AdvertPointServiceImpl implements AdvertPointService{
    private final AdvertPointDao advertPointDao;

    public AdvertPointServiceImpl(AdvertPointDao advertPointDao) {
        this.advertPointDao = advertPointDao;
    }

    @Override
    public AdvertPoint getAdvertPoint(String dspAppId, String dspPositionId) {
        if (Objects.isNull(dspAppId) || Objects.isNull(dspPositionId)) {
            return null;
        }
        return advertPointDao.getAdvertPoint(dspAppId, dspPositionId);
    }
}
