package com.bxm.adx.common.log;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.rolling.RollingFileAppender;
import com.bxm.adx.common.market.exchange.ExchangeContext;
import org.springframework.context.annotation.Configuration;

import java.util.Objects;

/**
 * 继承自 {@link RollingFileAppender}，当系统日志输出级别大于或等于 {@link #additivityLevel} 级别时，会将日志发送给父类处理。
 *
 * @author allen
 * @date 2021-07-22
 * @since 1.0.5
 */
@Configuration
public class TestRequestRollingFileAppender<E> extends RollingFileAppender<E> {

    /**
     * 附加日志级别，当日志大于等于这个级别时，会附加到日志文件里。
     * 如果没有设置，那么按照 logger.level 来处理。
     */
    private Level additivityLevel;

    @Override
    protected void subAppend(E event) {
        if (Objects.isNull(additivityLevel) || !(event instanceof ILoggingEvent)) {
            super.subAppend(event);
        } else {
            ILoggingEvent e = (ILoggingEvent) event;
            Level level = e.getLevel();
            if (level.isGreaterOrEqual(additivityLevel)) {
                if (ExchangeContext.getPluginLog()) {
                    super.subAppend(event);
                }
            }
        }
    }

    public void setAdditivityLevel(Level additivityLevel) {
        this.additivityLevel = additivityLevel;
    }
}
