package com.bxm.adx.common.market.filter;

import com.bxm.adx.common.market.Deal;
import lombok.extern.slf4j.Slf4j;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.util.ClassUtils;

import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;

/**
 * @author allen
 * @since 2019-12-18
 */
@Primary
@Configuration
@Slf4j
public class Filters implements Filter, ApplicationListener<ApplicationReadyEvent> {

    private Collection<Filter> filters;

    @Override
    public void onApplicationEvent(ApplicationReadyEvent event) {
        this.filters = event.getApplicationContext().getBeansOfType(Filter.class).values();
        // 需要排除自己
        this.filters.removeIf(filter -> Filters.class.equals(ClassUtils.getUserClass(filter)));
        this.filters = this.filters.stream().sorted(Comparator.comparing(Filter::getOrder)).collect(Collectors.toList());
    }

    @Override
    public void filter(List<Deal> deals) {
        if (log.isDebugEnabled()) {
            log.debug("before filter deal list size={}", deals.size());
        }
        for (Filter filter : filters) {
            filter.filter(deals);
            if (log.isDebugEnabled()) {
                log.debug("filter-{} deal list size={}",filter.getClass(), deals.size());
            }
        }

        if (log.isDebugEnabled()) {
            log.debug("after filter deal list size={}", deals.size());
        }
    }

    @Override
    public int getOrder() {
        return 0;
    }
}
