package com.bxm.adx.common.openlog.event.internal;

import com.bxm.adx.common.sell.BidConfig;
import com.bxm.adx.common.sell.BidRequest;
import com.bxm.adx.common.sell.BidResponse;

import java.util.EventObject;

/**
 * adx竞价返回事件
 * @author fgf
 * @date 2022/6/2
 */
public class AdxBidEvent extends EventObject {
    private final BidRequest sspRequest;
    private final BidResponse adxResponse;
    private final BidConfig bidConfig;
    /**
     * Constructs a prototypical Event.
     *
     * @param source The object on which the Event initially occurred.
     * @param sspRequest
     * @param adxResponse
     * @param bidConfig
     * @throws IllegalArgumentException if source is null.
     */
    public AdxBidEvent(Object source, BidRequest sspRequest, BidResponse adxResponse, BidConfig bidConfig) {
        super(source);
        this.sspRequest = sspRequest;
        this.adxResponse = adxResponse;
        this.bidConfig = bidConfig;
    }

    public BidRequest getSspRequest() {
        return sspRequest;
    }

    public BidResponse getAdxResponse() {
        return adxResponse;
    }

    public BidConfig getBidConfig() {
        return bidConfig;
    }
}
