package com.bxm.adx.common.openlog.event.internal;

import com.bxm.adx.common.sell.BidConfig;
import com.bxm.adx.common.sell.BidRequest;

import java.util.EventObject;

/**
 * 媒体发起请求事件
 * @author fgf
 * @date 2022/6/1
 **/
public class MediaRequestEvent extends EventObject {
    private final BidRequest sspRequest;
    private final BidConfig bidConfig;
    /**
     * Constructs a prototypical Event.
     *
     * @param source The object on which the Event initially occurred.
     * @param sspRequest
     * @param bidConfig
     * @throws IllegalArgumentException if source is null.
     */
    public MediaRequestEvent(Object source, BidRequest sspRequest, BidConfig bidConfig) {
        super(source);
        this.sspRequest = sspRequest;
        this.bidConfig = bidConfig;
    }

    public BidRequest getSspRequest() {
        return sspRequest;
    }

    public BidConfig getBidConfig() {
        return bidConfig;
    }
}
