package com.bxm.adx.common.pushable;

import com.bxm.warcar.integration.pushable.CachePushableBus;
import com.bxm.warcar.integration.pushable.message.CachePushableMessageListener;
import com.bxm.warcar.mq.redis.JedisConsumer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import redis.clients.jedis.JedisPool;

/**
 * 缓存推送消费者
 *
 * @author allen
 * @since 2019-12-27
 */
@Configuration
public class AdxPushableConsumer extends CachePushableMessageListener {

    private final JedisPool jedisPool;

    @Bean(initMethod = "init", destroyMethod = "destroy")
    public JedisConsumer pushableConsumer() {
        return new JedisConsumer(jedisPool, this);
    }

    public AdxPushableConsumer(CachePushableBus cachePushableBus, JedisPool jedisPool) {
        super("ADX_CACHE_PUSH", AdxPushableConsumer.class.getName(), cachePushableBus);
        this.jedisPool = jedisPool;
    }
}
