package com.bxm.adx.common.sell.builder;

import com.bxm.adx.common.OpenlogConstants;
import com.bxm.adx.common.sell.BidRequest;
import com.bxm.adx.common.sell.BidResponse;
import com.bxm.adx.common.sell.request.App;
import com.bxm.adx.common.sell.request.Impression;
import com.bxm.adx.common.sell.response.Bid;
import com.bxm.adx.common.sell.response.SeatBid;
import lombok.Data;
import lombok.experimental.Accessors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

import java.math.BigDecimal;
import java.util.List;
import java.util.Objects;

/**
 * 构造属性
 *
 * @author allen
 * @date 2021-06-16
 * @since 1.0
 */
@Data
@Accessors(chain = true)
public class BuildAttribute {
    public BuildAttribute(Integer mt) {
        this.mt = mt;
    }

    public BuildAttribute() {
    }

    /**
     * BidRequest
     */
    private BidRequest sspRequest;
    private BidRequest adxRequest;
    /**
     * BidResponse
     */
    private BidResponse adxResponse;
    private BidResponse dspResponse;
    /**
     * 价格/分
     */
    private BigDecimal sspRequestPrice;
    private BigDecimal adxRequestPrice;
    private BigDecimal dspResponsePrice;
    private BigDecimal adxResponsePrice;
    /**
     * 流量分配的配置ID
     */
    private String configId;
    /**
     * DSP平台ID
     */
    private String dspId;
    /**
     * SSP 媒体APPID
     */
    private String appId;
    /**
     * SSP 广告位ID
     */
    private String tagId;
    /**
     * DSP 媒体APPID
     */
    private String dAppId;
    /**
     * DSP 广告位ID
     */
    private String dTagId;

    /**
     * @see com.bxm.adx.common.OpenlogConstants.Mt
     */
    private Integer mt;

    /**
     * 媒体ID
     * @see com.bxm.adx.common.AdxConstants.Media
     */
    private String mediaId;

    public String getAppId() {
        if (Objects.isNull(sspRequest)) {
            return null;
        }
        App app = sspRequest.getApp();
        if (Objects.nonNull(app)) {
            return app.getId();
        }
        return null;
    }

    public String getTagId() {
        if (Objects.isNull(sspRequest)) {
            return null;
        }
        List<Impression> impressions = sspRequest.getImps();
        if (CollectionUtils.isNotEmpty(impressions)) {
            return impressions.iterator().next().getTag_id();
        }
        return null;
    }

    public String getdAppId() {
        if (Objects.nonNull(adxRequest)) {
            App app = adxRequest.getApp();
            if (Objects.nonNull(app)) {
                return app.getId();
            }
        }
        if (Objects.nonNull(adxResponse)) {
            List<SeatBid> seatBids = adxResponse.getSeat_bid();
            if (CollectionUtils.isNotEmpty(seatBids)) {
                SeatBid seatBid = seatBids.iterator().next();
                List<Bid> bids = seatBid.getBid();
                if (CollectionUtils.isNotEmpty(bids)) {
                    String appid = bids.iterator().next().getDsp_appid();
                    if (StringUtils.isEmpty(appid)) {
//                        return getAppId();
                    } else {
                        return appid;
                    }
                }
            }
        }
        return null;
    }

    public String getdTagId() {
        if (Objects.nonNull(adxRequest)) {
            List<Impression> impressions = adxRequest.getImps();
            if (CollectionUtils.isNotEmpty(impressions)) {
                return impressions.iterator().next().getTag_id();
            }
        }
        if (Objects.nonNull(adxResponse)) {
            List<SeatBid> seatBids = adxResponse.getSeat_bid();
            if (CollectionUtils.isNotEmpty(seatBids)) {
                SeatBid seatBid = seatBids.iterator().next();
                List<Bid> bids = seatBid.getBid();
                if (CollectionUtils.isNotEmpty(bids)) {
                    return bids.iterator().next().getTag_id();
                }
            }
        }
        return null;
    }

    public BigDecimal getSspRequestPrice() {
        if (Objects.nonNull(sspRequest)) {
            List<Impression> impressions = sspRequest.getImps();
            if (CollectionUtils.isNotEmpty(impressions)) {
                return impressions.iterator().next().getBid_floor();
            }
        }
        return null;
    }

    public BigDecimal getAdxRequestPrice() {
        if (Objects.nonNull(adxRequest)) {
            List<Impression> impressions = adxRequest.getImps();
            if (CollectionUtils.isNotEmpty(impressions)) {
                return impressions.iterator().next().getBid_floor();
            }
        }
        return null;
    }

    public BigDecimal getDspResponsePrice() {
        if (Objects.nonNull(dspResponse)) {
            List<SeatBid> seatBids = dspResponse.getSeat_bid();
            if (CollectionUtils.isNotEmpty(seatBids)) {
                SeatBid seatBid = seatBids.iterator().next();
                List<Bid> bids = seatBid.getBid();
                if (CollectionUtils.isNotEmpty(bids)) {
                    return bids.iterator().next().getDsp_price();
                }
            }
        }
        if (Objects.nonNull(adxResponse)) {
            List<SeatBid> seatBids = adxResponse.getSeat_bid();
            if (CollectionUtils.isNotEmpty(seatBids)) {
                SeatBid seatBid = seatBids.iterator().next();
                List<Bid> bids = seatBid.getBid();
                if (CollectionUtils.isNotEmpty(bids)) {
                    return bids.iterator().next().getDsp_price();
                }
            }
        }
        return null;
    }

    private BigDecimal getAdxResponsePrice() {
        if (Objects.nonNull(adxResponse)) {
            List<SeatBid> seatBids = adxResponse.getSeat_bid();
            if (CollectionUtils.isNotEmpty(seatBids)) {
                SeatBid seatBid = seatBids.iterator().next();
                List<Bid> bids = seatBid.getBid();
                if (CollectionUtils.isNotEmpty(bids)) {
                    return bids.iterator().next().getPrice();
                }
            }
        }
        return null;
    }

    public String getPrice() {
        if (Objects.nonNull(mt)) {
            switch (mt) {
                case OpenlogConstants.Mt.MEDIA_REQUEST_MT:
                    return getSspRequestPrice().toString();
                case OpenlogConstants.Mt.ADX_REQUEST_MT:
                    return getAdxRequestPrice().toString();
                case OpenlogConstants.Mt.DSP_RESPONSE_MT:
                    return getDspResponsePrice().toString();
                case OpenlogConstants.Mt.ADX_RESPONSE_MT:
                    return getAdxResponsePrice().toString();
                default:
                    return null;
            }
        }
        return null;
    }

    public String getMediaId() {
        if (Objects.nonNull(sspRequest)) {
            return sspRequest.getMediaId();
        }
        if (Objects.nonNull(adxRequest)) {
            return adxRequest.getMediaId();
        }
        return null;
    }
}
