package com.bxm.adx.common.sell.init;

import com.bxm.adx.common.AdxConstants;
import com.bxm.adx.common.PositionSceneTypeEnum;
import com.bxm.adx.common.sell.BidRequest;
import com.bxm.adx.common.sell.position.Position;
import com.bxm.adx.common.sell.request.Impression;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.StringUtils;

import java.util.Objects;

/**
 * @author fgf
 * @date 2022/8/26
 **/
@Configuration
public class ImpressionInitializer implements BidRequestInitializer {
    @Override
    public void accept(BidRequest request, InitializerParam param) {
        if (CollectionUtils.isNotEmpty(request.getImps())) {
            Position position = param.getPosition();
            if (Objects.isNull(position)) {
                return;
            }
            for (Impression impression : request.getImps()) {
                if (StringUtils.isEmpty(impression.getId())) {
                    impression.setId(request.getId());
                }
                if (StringUtils.isEmpty(impression.getImp_type())) {
                    impression.setImp_type(position.getPositionType());
                }

                initImpressionType(impression, position);
                insertOrUpdateImpressionSize(impression, param.getPosition());
            }
        }
    }

    /**
     * 填充impType
     * @param impression
     * @param position
     */
    private void initImpressionType(Impression impression, Position position){
        if (StringUtils.isEmpty(impression.getType())) {
            Integer positionType = position.getPositionType();
            PositionSceneTypeEnum typeEnum = PositionSceneTypeEnum.get(positionType);
            if (Objects.nonNull(typeEnum)) {
                switch (typeEnum) {
                    case BOOT:
                        impression.setType(AdxConstants.Type.IMAGE.getType());
                        break;
                    case INFORMATION_FLOW:
                        impression.setType(AdxConstants.Type.NATIVE.getType());
                }
            }
        }
    }

    /**
     * 填充imp尺寸
     * @param imp
     * @param position
     */
    private void insertOrUpdateImpressionSize(Impression imp, Position position) {
        imp.setTag_id(position.getPositionId());
        if (Objects.nonNull(imp.getW()) && Objects.nonNull(imp.getH())) {
            return;
        }
        String positionSize = position.getPositionSize();
        if (org.apache.commons.lang.StringUtils.isBlank(positionSize)) {
            return;
        }
        String[] sizeArray = positionSize.split(" ")[0].split("\\*");
        if (sizeArray.length != 2) {
            return;
        }
        if (org.apache.commons.lang.StringUtils.isNumeric(sizeArray[0])) {
            imp.setW(Integer.parseInt(sizeArray[0]));
        }
        if (org.apache.commons.lang.StringUtils.isNumeric(sizeArray[1])) {
            imp.setH(Integer.parseInt(sizeArray[1]));
        }
    }

    @Override
    public int getOrder() {
        return 0;
    }
}
