/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adx.common.adapter;

import com.bxm.adx.common.adapter.AdxContext;
import com.bxm.adx.common.adapter.AdxContextFactory;
import com.bxm.adx.common.adapter.BidModelAdapter;
import com.bxm.adx.common.adapter.builder.Interpreter;
import com.bxm.adx.common.cipher.CipherService;
import com.bxm.adx.common.sell.BidRequest;
import com.bxm.adx.common.sell.BidResponse;
import com.bxm.adx.common.sell.ssp.SspRequest;
import com.bxm.adx.common.sell.ssp.SspResponse;
import com.bxm.adx.common.sell.ssp.resp.Ad;
import com.bxm.adx.common.utils.AdxUtils;
import com.bxm.warcar.utils.JsonHelper;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.codec.digest.DigestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BxmSspBidModelAdapter
implements BidModelAdapter {
    private static final Logger log = LoggerFactory.getLogger(BxmSspBidModelAdapter.class);
    @Resource
    private Interpreter interpreter;
    @Resource
    private CipherService cipherService;

    @Override
    public BidRequest convert(byte[] bytes) {
        SspRequest sspRequest = (SspRequest)JsonHelper.convert((byte[])bytes, SspRequest.class);
        BidRequest request = new BidRequest();
        this.interpreter.translate(sspRequest, request);
        if (log.isDebugEnabled()) {
            log.debug("bidrequest={}", (Object)JsonHelper.convert((Object)request));
        }
        AdxContext adxContext = AdxContextFactory.get();
        adxContext.setAttachment(sspRequest);
        adxContext.setUid(AdxUtils.getUidV2(request));
        return request;
    }

    @Override
    public byte[] convert(BidResponse e, BidRequest bidRequest) {
        if (log.isDebugEnabled()) {
            log.debug("bidresponse={}", (Object)JsonHelper.convert((Object)e));
        }
        SspResponse sspResponse = new SspResponse();
        this.interpreter.translate(e, bidRequest, sspResponse);
        byte[] bytes = JsonHelper.convert2bytes((Object)sspResponse);
        AdxContext context = AdxContextFactory.get();
        Object attachment = context.getAttachment();
        if (attachment instanceof SspRequest && context.isCipherAesForResponse()) {
            List<Ad> ads = sspResponse.getAds();
            String content = JsonHelper.convert(ads);
            try {
                String key = DigestUtils.md5Hex((byte[])JsonHelper.convert2bytes((Object)attachment));
                String ciphertext = this.cipherService.aesEncrypt(content, key);
                String requestId = this.cipherService.generateRequestId(key);
                sspResponse.setCiphertext(ciphertext);
                sspResponse.setRequestId(requestId);
                return JsonHelper.convert2bytes((Object)sspResponse);
            }
            catch (Exception ex) {
                log.warn("encrypt: ", (Throwable)ex);
            }
        }
        return bytes;
    }
}

