/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adx.common.adapter.builder;

import com.bxm.adx.common.adapter.builder.AdxRequestBuilder;
import com.bxm.adx.common.adapter.builder.SspResponseBuilder;
import com.bxm.adx.common.sell.BidRequest;
import com.bxm.adx.common.sell.BidResponse;
import com.bxm.adx.common.sell.ssp.SspRequest;
import com.bxm.adx.common.sell.ssp.SspResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class Interpreter {
    private static final Logger log = LoggerFactory.getLogger(Interpreter.class);
    private AdxRequestBuilder adxRequestBuilder;
    private SspResponseBuilder sspResponseBuilder;

    public Interpreter(AdxRequestBuilder adxRequestBuilder, SspResponseBuilder sspResponseBuilder) {
        this.adxRequestBuilder = adxRequestBuilder;
        this.sspResponseBuilder = sspResponseBuilder;
    }

    public void translate(SspRequest sspRequest, BidRequest request) {
        this.adxRequestBuilder.buildId(sspRequest, request);
        this.adxRequestBuilder.buildAdxType(sspRequest, request);
        this.adxRequestBuilder.buildImps(sspRequest, request);
        this.adxRequestBuilder.buildcType(sspRequest, request);
        this.adxRequestBuilder.buildApp(sspRequest, request);
        this.adxRequestBuilder.buildDevice(sspRequest, request);
        this.adxRequestBuilder.buildUser(sspRequest, request);
        this.adxRequestBuilder.buildGeo(sspRequest, request);
        this.adxRequestBuilder.buildCur(sspRequest, request);
        this.adxRequestBuilder.buildBidType(sspRequest, request);
        this.adxRequestBuilder.buildAt(sspRequest, request);
        this.adxRequestBuilder.buildDealIds(sspRequest, request);
        this.adxRequestBuilder.buildBillType(sspRequest, request);
        this.adxRequestBuilder.buildTest(sspRequest, request);
        this.adxRequestBuilder.buildtMax(sspRequest, request);
        this.adxRequestBuilder.buildbCat(sspRequest, request);
        this.adxRequestBuilder.buildbSeat(sspRequest, request);
        this.adxRequestBuilder.buildwSeat(sspRequest, request);
        this.adxRequestBuilder.buildbAdv(sspRequest, request);
        this.adxRequestBuilder.buildbApp(sspRequest, request);
        this.adxRequestBuilder.buildExt(sspRequest, request);
        this.adxRequestBuilder.buildAdType(sspRequest, request);
        this.adxRequestBuilder.buildSdkVer(sspRequest, request);
        this.adxRequestBuilder.buildRequestModel(sspRequest, request);
    }

    public void translate(BidResponse bidResponse, BidRequest bidRequest, SspResponse sspResponse) {
        this.sspResponseBuilder.buildResult(bidResponse, sspResponse);
        this.sspResponseBuilder.buildMsg(bidResponse, sspResponse);
        this.sspResponseBuilder.buildAds(bidResponse, bidRequest, sspResponse);
    }
}

