/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adx.common.buy.dispatcher;

import java.math.BigDecimal;
import java.util.List;
import java.util.Objects;

public class DispatcherParam {
    private BigDecimal minPrice;
    private BigDecimal maxPrice;
    private List<String> installAppList;
    private String mediaAppPackageName;

    public boolean isSDKConcurrentModel() {
        return Objects.nonNull(this.minPrice) && Objects.nonNull(this.maxPrice) && this.maxPrice.compareTo(BigDecimal.ZERO) > 0;
    }

    DispatcherParam(BigDecimal minPrice, BigDecimal maxPrice, List<String> installAppList, String mediaAppPackageName) {
        this.minPrice = minPrice;
        this.maxPrice = maxPrice;
        this.installAppList = installAppList;
        this.mediaAppPackageName = mediaAppPackageName;
    }

    public static DispatcherParamBuilder builder() {
        return new DispatcherParamBuilder();
    }

    public BigDecimal getMinPrice() {
        return this.minPrice;
    }

    public BigDecimal getMaxPrice() {
        return this.maxPrice;
    }

    public List<String> getInstallAppList() {
        return this.installAppList;
    }

    public String getMediaAppPackageName() {
        return this.mediaAppPackageName;
    }

    public void setMinPrice(BigDecimal minPrice) {
        this.minPrice = minPrice;
    }

    public void setMaxPrice(BigDecimal maxPrice) {
        this.maxPrice = maxPrice;
    }

    public void setInstallAppList(List<String> installAppList) {
        this.installAppList = installAppList;
    }

    public void setMediaAppPackageName(String mediaAppPackageName) {
        this.mediaAppPackageName = mediaAppPackageName;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DispatcherParam)) {
            return false;
        }
        DispatcherParam other = (DispatcherParam)o;
        if (!other.canEqual(this)) {
            return false;
        }
        BigDecimal this$minPrice = this.getMinPrice();
        BigDecimal other$minPrice = other.getMinPrice();
        if (this$minPrice == null ? other$minPrice != null : !((Object)this$minPrice).equals(other$minPrice)) {
            return false;
        }
        BigDecimal this$maxPrice = this.getMaxPrice();
        BigDecimal other$maxPrice = other.getMaxPrice();
        if (this$maxPrice == null ? other$maxPrice != null : !((Object)this$maxPrice).equals(other$maxPrice)) {
            return false;
        }
        List<String> this$installAppList = this.getInstallAppList();
        List<String> other$installAppList = other.getInstallAppList();
        if (this$installAppList == null ? other$installAppList != null : !((Object)this$installAppList).equals(other$installAppList)) {
            return false;
        }
        String this$mediaAppPackageName = this.getMediaAppPackageName();
        String other$mediaAppPackageName = other.getMediaAppPackageName();
        return !(this$mediaAppPackageName == null ? other$mediaAppPackageName != null : !this$mediaAppPackageName.equals(other$mediaAppPackageName));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DispatcherParam;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        BigDecimal $minPrice = this.getMinPrice();
        result = result * 59 + ($minPrice == null ? 43 : ((Object)$minPrice).hashCode());
        BigDecimal $maxPrice = this.getMaxPrice();
        result = result * 59 + ($maxPrice == null ? 43 : ((Object)$maxPrice).hashCode());
        List<String> $installAppList = this.getInstallAppList();
        result = result * 59 + ($installAppList == null ? 43 : ((Object)$installAppList).hashCode());
        String $mediaAppPackageName = this.getMediaAppPackageName();
        result = result * 59 + ($mediaAppPackageName == null ? 43 : $mediaAppPackageName.hashCode());
        return result;
    }

    public String toString() {
        return "DispatcherParam(minPrice=" + this.getMinPrice() + ", maxPrice=" + this.getMaxPrice() + ", installAppList=" + this.getInstallAppList() + ", mediaAppPackageName=" + this.getMediaAppPackageName() + ")";
    }

    public static class DispatcherParamBuilder {
        private BigDecimal minPrice;
        private BigDecimal maxPrice;
        private List<String> installAppList;
        private String mediaAppPackageName;

        DispatcherParamBuilder() {
        }

        public DispatcherParamBuilder minPrice(BigDecimal minPrice) {
            this.minPrice = minPrice;
            return this;
        }

        public DispatcherParamBuilder maxPrice(BigDecimal maxPrice) {
            this.maxPrice = maxPrice;
            return this;
        }

        public DispatcherParamBuilder installAppList(List<String> installAppList) {
            this.installAppList = installAppList;
            return this;
        }

        public DispatcherParamBuilder mediaAppPackageName(String mediaAppPackageName) {
            this.mediaAppPackageName = mediaAppPackageName;
            return this;
        }

        public DispatcherParam build() {
            return new DispatcherParam(this.minPrice, this.maxPrice, this.installAppList, this.mediaAppPackageName);
        }

        public String toString() {
            return "DispatcherParam.DispatcherParamBuilder(minPrice=" + this.minPrice + ", maxPrice=" + this.maxPrice + ", installAppList=" + this.installAppList + ", mediaAppPackageName=" + this.mediaAppPackageName + ")";
        }
    }
}

