/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adx.common.buy.position;

import com.bxm.adx.common.buy.position.AdvertPoint;
import com.bxm.adx.common.buy.position.AdvertPointDao;
import com.bxm.warcar.cache.Fetcher;
import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.cache.Updater;
import com.bxm.warcar.cache.push.Pushable;
import com.bxm.warcar.integration.pushable.annotation.CachePush;
import com.bxm.warcar.utils.JsonHelper;
import com.bxm.warcar.utils.KeyBuilder;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@CachePush(value="ADVERT_POINT")
@Component
public class AdvertPointDaoImpl
implements AdvertPointDao,
Pushable {
    private static final Logger log = LoggerFactory.getLogger(AdvertPointDaoImpl.class);
    private final Fetcher fetcher;
    private final Updater updater;

    public AdvertPointDaoImpl(Fetcher fetcher, Updater updater) {
        this.fetcher = fetcher;
        this.updater = updater;
    }

    public void push(Map<String, Object> parameters, byte[] data) {
        AdvertPoint advertPoint;
        if (log.isWarnEnabled()) {
            log.warn("advert point data = {}", JsonHelper.convert((byte[])data, String.class));
        }
        if (this.checkData(advertPoint = (AdvertPoint)JsonHelper.convert((byte[])data, AdvertPoint.class))) {
            return;
        }
        KeyGenerator keyGenerator = this.getKeyGenerator(advertPoint.getAppId(), advertPoint.getPositionId());
        this.updater.remove(keyGenerator);
        if (Objects.nonNull(advertPoint.getDeleted()) && advertPoint.getDeleted() == 0) {
            this.updater.update(keyGenerator, (Object)advertPoint);
        }
    }

    private KeyGenerator getKeyGenerator(String dspAppId, String dspPositionId) {
        return () -> KeyBuilder.build((Object[])new Object[]{"ADX", "ADVERT_POINT", dspAppId, dspPositionId});
    }

    private boolean checkData(AdvertPoint advertPoint) {
        if (Objects.isNull(advertPoint)) {
            return true;
        }
        if (Objects.isNull(advertPoint.getAppId()) || Objects.isNull(advertPoint.getPositionId())) {
            return true;
        }
        return Objects.isNull(advertPoint.getDeleted());
    }

    @Override
    public AdvertPoint getAdvertPoint(String dspAppId, String dspPositionId) {
        return (AdvertPoint)this.fetcher.fetch(this.getKeyGenerator(dspAppId, dspPositionId), AdvertPoint.class);
    }
}

