/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adx.common.collection;

import com.bxm.adx.common.collection.PositionCollectionDao;
import com.bxm.adx.common.collection.PositionCollectionRequest;
import com.bxm.adx.common.collection.PositionCollectionService;
import com.bxm.adx.facade.constant.enums.AdxErrEnum;
import com.bxm.adx.facade.constant.enums.AppPlatformTypeEnum;
import com.bxm.adx.facade.constant.enums.DevOsEnum;
import com.bxm.adx.facade.exception.AdxException;
import com.bxm.mccms.facade.model.pushable.PositionCollectionCacheVO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Configuration;

@Configuration
public class PositionCollectionServiceImpl
implements PositionCollectionService {
    private static final Logger log = LoggerFactory.getLogger(PositionCollectionServiceImpl.class);
    private final PositionCollectionDao positionCollectionDao;

    public PositionCollectionServiceImpl(PositionCollectionDao positionCollectionDao) {
        this.positionCollectionDao = positionCollectionDao;
    }

    @Override
    public PositionCollectionCacheVO getByPositionId(PositionCollectionRequest positionCollectionRequest) {
        String positionId = positionCollectionRequest.getPositionId();
        PositionCollectionCacheVO position = this.positionCollectionDao.getByPositionId(positionId);
        if (null == position) {
            if (log.isDebugEnabled()) {
                log.debug("\u5e7f\u544a\u4f4dSDK\u914d\u7f6e\u4e2d\uff0c\u6ca1\u6709\u83b7\u53d6\u5230\uff1a{} \u7684\u5e7f\u544a\u4f4d\u4fe1\u606f\u3002", (Object)positionId);
            }
            return position;
        }
        if (position.getPositionScene().byteValue() != positionCollectionRequest.getPositionScene().byteValue()) {
            throw new AdxException(AdxErrEnum.POSITION_SCENE_MISMATCH);
        }
        AppPlatformTypeEnum platformTypeEnum = AppPlatformTypeEnum.of((Integer)position.getPlatformType());
        DevOsEnum osEnum = DevOsEnum.of((Integer)positionCollectionRequest.getOs());
        switch (osEnum) {
            case IOS: {
                if (AppPlatformTypeEnum.IOS == platformTypeEnum) break;
                throw new AdxException(AdxErrEnum.POSITION_OS_MISMATCH);
            }
            case ANDROID: {
                if (AppPlatformTypeEnum.ANDROID == platformTypeEnum) break;
                throw new AdxException(AdxErrEnum.POSITION_OS_MISMATCH);
            }
        }
        return position;
    }
}

