/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adx.common.ding;

import com.bxm.adx.common.AdxConstants;
import com.bxm.adx.common.CacheKeys;
import com.bxm.adx.common.ding.DingTalkService;
import com.bxm.warcar.cache.Fetcher;
import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.cache.Updater;
import com.bxm.warcar.message.Message;
import com.bxm.warcar.message.MessageSender;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="dingTalkService")
public class DingTalkServiceImpl
implements DingTalkService {
    private static final Logger log = LoggerFactory.getLogger(DingTalkServiceImpl.class);
    private MessageSender dingDingMessageSender;
    private Fetcher fetcher;
    private Updater updater;

    public DingTalkServiceImpl(MessageSender dingDingMessageSender, Fetcher fetcher, Updater updater) {
        this.dingDingMessageSender = dingDingMessageSender;
        this.fetcher = fetcher;
        this.updater = updater;
    }

    @Override
    public void pushSDKActivityErr(String positionId, AdxConstants.ActivityErr err) {
        block5: {
            try {
                KeyGenerator keyGenerator = CacheKeys.getActivityErrGenerator(positionId, err.name());
                if (this.fetcher.exists(keyGenerator)) {
                    if (log.isDebugEnabled()) {
                        log.debug("posid = {} have been reported ,err = {}", (Object)positionId, (Object)err.name());
                    }
                    return;
                }
                Message message = new Message();
                message.setContent("posId = " + positionId + ", err = " + err.name());
                this.dingDingMessageSender.send2(message);
                this.updater.update(keyGenerator, (Object)"1", 86400);
                if (log.isDebugEnabled()) {
                    log.debug("report posid = {} ,err = {}", (Object)positionId, (Object)err.name());
                }
            }
            catch (Exception e) {
                if (!log.isErrorEnabled()) break block5;
                log.error("ding err", (Throwable)e);
            }
        }
    }
}

