/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adx.common.market;

import com.bxm.adx.common.buy.buyers.BuyerWrapper;
import com.bxm.adx.common.sell.position.Position;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Set;

public class MarketRequest {
    private int priority;
    private Set<BuyerWrapper> buyers = Sets.newHashSet();
    private Set<Position> positions = Sets.newHashSet();

    public MarketRequest(int priority) {
        this.priority = priority;
    }

    public void addBuyer(BuyerWrapper buyer) {
        this.buyers.add(buyer);
    }

    public void addBuyers(Collection<BuyerWrapper> buyers) {
        this.buyers.addAll(buyers);
    }

    public void addPosition(Position position) {
        this.positions.add(position);
    }

    public int getPriority() {
        return this.priority;
    }

    public Set<BuyerWrapper> getBuyers() {
        return this.buyers;
    }

    public Set<Position> getPositions() {
        return this.positions;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public void setBuyers(Set<BuyerWrapper> buyers) {
        this.buyers = buyers;
    }

    public void setPositions(Set<Position> positions) {
        this.positions = positions;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MarketRequest)) {
            return false;
        }
        MarketRequest other = (MarketRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getPriority() != other.getPriority()) {
            return false;
        }
        Set<BuyerWrapper> this$buyers = this.getBuyers();
        Set<BuyerWrapper> other$buyers = other.getBuyers();
        if (this$buyers == null ? other$buyers != null : !((Object)this$buyers).equals(other$buyers)) {
            return false;
        }
        Set<Position> this$positions = this.getPositions();
        Set<Position> other$positions = other.getPositions();
        return !(this$positions == null ? other$positions != null : !((Object)this$positions).equals(other$positions));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MarketRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getPriority();
        Set<BuyerWrapper> $buyers = this.getBuyers();
        result = result * 59 + ($buyers == null ? 43 : ((Object)$buyers).hashCode());
        Set<Position> $positions = this.getPositions();
        result = result * 59 + ($positions == null ? 43 : ((Object)$positions).hashCode());
        return result;
    }

    public String toString() {
        return "MarketRequest(priority=" + this.getPriority() + ", buyers=" + this.getBuyers() + ", positions=" + this.getPositions() + ")";
    }
}

