/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adx.common.sdkrounds;

import com.bxm.adx.common.sdkrounds.SdkRoundsDao;
import com.bxm.mccms.facade.model.pushable.PositionSdkRoundsCacheVO;
import com.bxm.warcar.cache.Fetcher;
import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.cache.Updater;
import com.bxm.warcar.cache.push.Pushable;
import com.bxm.warcar.integration.pushable.annotation.CachePush;
import com.bxm.warcar.utils.JsonHelper;
import com.bxm.warcar.utils.KeyBuilder;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Component;

@Component
@CachePush(value="POSITION_SDK_ROUNDS")
public class SdkRoundsDaoImpl
implements SdkRoundsDao,
Pushable {
    private final Fetcher fetcher;
    private final Updater updater;

    public SdkRoundsDaoImpl(Fetcher fetcher, Updater updater) {
        this.fetcher = fetcher;
        this.updater = updater;
    }

    @Override
    public List<PositionSdkRoundsCacheVO> getByPositionId(String positionId) {
        return this.fetcher.fetchList(this.getKeyGenerator(positionId), PositionSdkRoundsCacheVO.class);
    }

    public void push(Map<String, Object> parameters, byte[] data) {
        Object o = parameters.get("positionId");
        if (Objects.isNull(o)) {
            return;
        }
        String positionId = Objects.toString(o);
        List sdkRoundsList = (List)JsonHelper.convert((byte[])data, List.class);
        this.updater.remove(this.getKeyGenerator(positionId));
        if (CollectionUtils.isNotEmpty((Collection)sdkRoundsList)) {
            this.updater.update(this.getKeyGenerator(positionId), (Object)sdkRoundsList);
        }
    }

    private KeyGenerator getKeyGenerator(String value) {
        return () -> KeyBuilder.build((Object[])new Object[]{"ADX", "POSITION_SDK_ROUNDS", "POSITION_ID", value});
    }
}

