/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adx.common.sell;

import com.bxm.adx.common.AdxConstants;
import com.bxm.adx.common.AdxProperties;
import com.bxm.adx.common.adapter.AdxContextFactory;
import com.bxm.adx.common.buy.buyers.BuyerWrapper;
import com.bxm.adx.common.buy.buyers.PriorityBuyers;
import com.bxm.adx.common.buy.dispatcher.DispatcherParam;
import com.bxm.adx.common.market.MarketOrders;
import com.bxm.adx.common.market.MarketRequest;
import com.bxm.adx.common.openlog.event.internal.MediaRequestEvent;
import com.bxm.adx.common.sell.BidConfig;
import com.bxm.adx.common.sell.BidRequest;
import com.bxm.adx.common.sell.BidRequestWrapper;
import com.bxm.adx.common.sell.init.BidRequestInitializer;
import com.bxm.adx.common.sell.init.InitializerParam;
import com.bxm.adx.common.sell.position.Position;
import com.bxm.adx.common.sell.position.PositionService;
import com.bxm.adx.common.sell.request.App;
import com.bxm.adx.common.sell.request.Device;
import com.bxm.adx.common.sell.request.Impression;
import com.bxm.adx.facade.constant.enums.AdxErrEnum;
import com.bxm.adx.facade.exception.AdxException;
import com.bxm.user.id.generator.DeviceHelper;
import com.bxm.user.id.generator.DeviceInfo;
import com.bxm.warcar.integration.eventbus.EventPark;
import com.bxm.warcar.utils.JsonHelper;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.Ordered;
import org.springframework.util.CollectionUtils;

@Configuration
public class DefaultBidRequestWrapper
implements BidRequestWrapper,
ApplicationListener<ApplicationReadyEvent> {
    private static final Logger log = LoggerFactory.getLogger(DefaultBidRequestWrapper.class);
    private final PriorityBuyers priorityBuyers;
    private final PositionService positionService;
    private final AdxProperties properties;
    private final EventPark eventPark;
    private List<BidRequestInitializer> initializers = Lists.newArrayList();

    public DefaultBidRequestWrapper(PriorityBuyers priorityBuyers, PositionService positionService, AdxProperties properties, EventPark eventPark) {
        this.priorityBuyers = priorityBuyers;
        this.positionService = positionService;
        this.properties = properties;
        this.eventPark = eventPark;
    }

    public void onApplicationEvent(ApplicationReadyEvent event) {
        this.initializers.addAll(event.getApplicationContext().getBeansOfType(BidRequestInitializer.class).values());
        this.initializers.sort(Comparator.comparingInt(Ordered::getOrder));
    }

    @Override
    public MarketOrders packing(BidRequest bidRequest) {
        if (null == bidRequest) {
            return null;
        }
        List<Impression> imps = bidRequest.getImps();
        if (CollectionUtils.isEmpty(imps)) {
            throw new AdxException(AdxErrEnum.POSITION_NOT_FOUND);
        }
        AdxContextFactory.get().setBidRequest(bidRequest);
        Impression impression = bidRequest.getImps().iterator().next();
        Position mediaPosition = this.getPositionByBidRequest(bidRequest, impression);
        HashMap positionListMap = Maps.newHashMap();
        ArrayList<Position> positionList = new ArrayList<Position>();
        if (Objects.nonNull(mediaPosition) && mediaPosition.isEnabled()) {
            positionList.add(mediaPosition);
            AdxContextFactory.get().setPosition(mediaPosition);
            this.initializers.forEach(init -> init.accept(bidRequest, InitializerParam.builder().position(mediaPosition).build()));
            DispatcherParam dispatcherParam = DispatcherParam.builder().minPrice(impression.getBid_floor()).maxPrice(impression.getBid_top()).installAppList(Objects.nonNull(bidRequest.getUser()) ? bidRequest.getUser().getInstalled_app_list() : null).mediaAppPackageName(Objects.nonNull(bidRequest.getApp()) ? bidRequest.getApp().getBundle() : null).build();
            List<List<BuyerWrapper>> buyers = this.priorityBuyers.findAsPriority(mediaPosition, dispatcherParam);
            this.priorityBuyers.rebuildBuyers(bidRequest, mediaPosition, buyers);
            positionListMap.put(mediaPosition, buyers);
        }
        if (CollectionUtils.isEmpty((Map)positionListMap)) {
            throw new AdxException(AdxErrEnum.POSITION_NOT_FOUND);
        }
        BidConfig bidConfig = new BidConfig().setDisDot(Math.abs(bidRequest.getId().hashCode() % 100) >= this.properties.getDotSimplingPercent());
        AdxContextFactory.get().setBidConfig(bidConfig);
        this.eventPark.post((EventObject)new MediaRequestEvent(this, bidRequest, bidConfig));
        ArrayList requests = Lists.newArrayListWithCapacity((int)this.properties.getMaxCapacityOfBuyers());
        for (Map.Entry positionListEntry : positionListMap.entrySet()) {
            Position position = (Position)positionListEntry.getKey();
            List list = (List)positionListEntry.getValue();
            int level = list.size();
            if (level == 0) continue;
            for (int i = 0; i < level; ++i) {
                MarketRequest marketRequest;
                List array = (List)list.get(i);
                if (CollectionUtils.isEmpty((Collection)array)) continue;
                MarketRequest marketRequest2 = CollectionUtils.isEmpty((Collection)requests) ? null : (marketRequest = requests.size() > i ? (MarketRequest)requests.get(i) : null);
                if (null == marketRequest) {
                    marketRequest = new MarketRequest(i);
                    requests.add(i, marketRequest);
                }
                marketRequest.addBuyers(array);
                marketRequest.addPosition(position);
            }
        }
        MarketOrders marketOrders = new MarketOrders(bidRequest, requests, positionList, this.getUid(bidRequest));
        if (log.isDebugEnabled()) {
            log.debug("{}", (Object)JsonHelper.convert((Object)marketOrders));
        }
        return marketOrders;
    }

    private String getUid(BidRequest bidRequest) {
        Device device = bidRequest.getDevice();
        if (device == null) {
            return null;
        }
        DeviceInfo info = new DeviceInfo().setImei(device.getImei()).setImeiMd5(device.getImei_md5()).setOaid(device.getOaid()).setOaidMd5(device.getOaid_md5()).setAnid(device.getDpid()).setAnidMd5(device.getDpid_md5()).setIdfa(device.getIdfa()).setIdfaMd5(device.getIdfa_md5()).setOs(device.isAndroid() ? 1 : (device.isIos() ? 2 : 0));
        return DeviceHelper.getUid((DeviceInfo)info);
    }

    private Position getPositionByBidRequest(BidRequest bidRequest, Impression impression) {
        String tagId = impression.getTag_id();
        Position position = null;
        if (StringUtils.isBlank((String)tagId)) {
            AdxConstants.Media media;
            if (Objects.nonNull(bidRequest.getMediaId()) && AdxConstants.Media.Bes == (media = AdxConstants.Media.of(Integer.parseInt(bidRequest.getMediaId())))) {
                App app = bidRequest.getApp();
                position = this.positionService.getByPositionId(this.properties.getBesAppId(), impression.getW(), impression.getH(), impression.getImp_type(), app.getId());
            }
        } else {
            position = this.positionService.getByPositionId(tagId);
        }
        return position;
    }
}

