/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adx.common.utils;

import com.bxm.adx.common.utils.AbstractSyncProcessor;
import com.bxm.adx.common.utils.FileHelper;
import java.io.File;
import java.util.Arrays;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.function.Consumer;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;

public abstract class AbstractWriteToFileSyncProcessor
extends AbstractSyncProcessor<Line>
implements InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(AbstractWriteToFileSyncProcessor.class);
    private final String parentDir;

    public AbstractWriteToFileSyncProcessor(int coreSize, int maximumLength, String threadName, RejectedExecutionHandler rejectedExecutionHandler, String parentDir) {
        super(coreSize, maximumLength, threadName, rejectedExecutionHandler);
        this.parentDir = parentDir;
    }

    @Override
    protected Consumer<Line> getConsumer() {
        return new Consumer<Line>(){

            @Override
            public void accept(Line line) {
                try {
                    String fileName = line.getFileName();
                    File file = new File(AbstractWriteToFileSyncProcessor.this.parentDir + fileName);
                    FileUtils.writeByteArrayToFile((File)file, (byte[])line.getData(), (boolean)line.isAppend());
                }
                catch (Exception e) {
                    log.error("writeLines: ", (Throwable)e);
                }
            }
        };
    }

    public void afterPropertiesSet() {
        FileHelper.createDirIfNecessary(this.parentDir);
    }

    public static class Line {
        private String fileName;
        private byte[] data;
        private boolean append;

        public static LineBuilder builder() {
            return new LineBuilder();
        }

        public String getFileName() {
            return this.fileName;
        }

        public byte[] getData() {
            return this.data;
        }

        public boolean isAppend() {
            return this.append;
        }

        public void setFileName(String fileName) {
            this.fileName = fileName;
        }

        public void setData(byte[] data) {
            this.data = data;
        }

        public void setAppend(boolean append) {
            this.append = append;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Line)) {
                return false;
            }
            Line other = (Line)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isAppend() != other.isAppend()) {
                return false;
            }
            String this$fileName = this.getFileName();
            String other$fileName = other.getFileName();
            if (this$fileName == null ? other$fileName != null : !this$fileName.equals(other$fileName)) {
                return false;
            }
            return Arrays.equals(this.getData(), other.getData());
        }

        protected boolean canEqual(Object other) {
            return other instanceof Line;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isAppend() ? 79 : 97);
            String $fileName = this.getFileName();
            result = result * 59 + ($fileName == null ? 43 : $fileName.hashCode());
            result = result * 59 + Arrays.hashCode(this.getData());
            return result;
        }

        public String toString() {
            return "AbstractWriteToFileSyncProcessor.Line(fileName=" + this.getFileName() + ", data=" + Arrays.toString(this.getData()) + ", append=" + this.isAppend() + ")";
        }

        public Line(String fileName, byte[] data, boolean append) {
            this.fileName = fileName;
            this.data = data;
            this.append = append;
        }

        public static class LineBuilder {
            private String fileName;
            private byte[] data;
            private boolean append;

            LineBuilder() {
            }

            public LineBuilder fileName(String fileName) {
                this.fileName = fileName;
                return this;
            }

            public LineBuilder data(byte[] data) {
                this.data = data;
                return this;
            }

            public LineBuilder append(boolean append) {
                this.append = append;
                return this;
            }

            public Line build() {
                return new Line(this.fileName, this.data, this.append);
            }

            public String toString() {
                return "AbstractWriteToFileSyncProcessor.Line.LineBuilder(fileName=" + this.fileName + ", data=" + Arrays.toString(this.data) + ", append=" + this.append + ")";
            }
        }
    }
}

