/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adx.common.utils;

import com.bxm.adx.common.sell.BidRequest;
import com.bxm.adx.common.sell.request.Device;
import com.bxm.adx.common.utils.DevHelper;
import com.bxm.adx.facade.constant.enums.AdxErrEnum;
import com.bxm.mcssp.common.entity.PositionJsonConfig;
import com.bxm.warcar.utils.JsonHelper;
import com.bxm.warcar.utils.StringHelper;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;

public class AdxUtils {
    private static final String ILLEGAL_REGION_CODE_SUFFIX = "0000";

    public static String getUidV2(BidRequest request) {
        Device device = request.getDevice();
        if (null != device) {
            return DevHelper.getUid(device);
        }
        return null;
    }

    @Deprecated
    public static String getUid(BidRequest request) {
        Device device = request.getDevice();
        if (null != device) {
            String imei = device.getImei();
            String imeiMD5 = device.getImei_md5();
            String idfa = device.getIdfa();
            String idfaMD5 = device.getIdfa_md5();
            String dpid = device.getDpid();
            String dpidMD5 = device.getDpid_md5();
            if (!org.springframework.util.StringUtils.isEmpty((Object)imei)) {
                return imei;
            }
            if (!org.springframework.util.StringUtils.isEmpty((Object)imeiMD5)) {
                return imeiMD5;
            }
            if (!org.springframework.util.StringUtils.isEmpty((Object)idfa)) {
                return idfa;
            }
            if (!org.springframework.util.StringUtils.isEmpty((Object)idfaMD5)) {
                return idfaMD5;
            }
            if (!org.springframework.util.StringUtils.isEmpty((Object)dpid)) {
                return dpid;
            }
            if (!org.springframework.util.StringUtils.isEmpty((Object)dpidMD5)) {
                return dpidMD5;
            }
            return null;
        }
        return null;
    }

    public static String getImei(Device device) {
        if (null != device) {
            if (org.springframework.util.StringUtils.isEmpty((Object)device.getImei())) {
                return device.getImei_md5();
            }
            return device.getImei();
        }
        return null;
    }

    public static String getIdfa(Device device) {
        if (null != device) {
            if (org.springframework.util.StringUtils.isEmpty((Object)device.getIdfa())) {
                return device.getIdfa_md5();
            }
            return device.getIdfa();
        }
        return null;
    }

    public static Map<String, Integer> getPositionSize(String positionSize) {
        String[] split = positionSize.split("\\*");
        HashMap<String, Integer> sizeMap = new HashMap<String, Integer>();
        if (split.length == 2) {
            if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)split[0])) {
                return null;
            }
            sizeMap.put("w", Integer.valueOf(split[0]));
            sizeMap.put("h", Integer.valueOf(split[1].split("\\s+")[0]));
            return sizeMap;
        }
        if (split.length < 2) {
            return null;
        }
        sizeMap.put("w", Integer.valueOf(split[0]));
        sizeMap.put("h", Integer.valueOf(split[1]));
        return sizeMap;
    }

    public static PositionJsonConfig getJsonConfig(String jsonConfig) {
        if (org.springframework.util.StringUtils.isEmpty((Object)jsonConfig)) {
            return null;
        }
        PositionJsonConfig positionJsonConfig = (PositionJsonConfig)JsonHelper.convert((String)jsonConfig, PositionJsonConfig.class);
        return positionJsonConfig;
    }

    public static int getBucket(String devNo) {
        return Math.abs(devNo.hashCode() % 100);
    }

    public static boolean isMatchRegion(String regionCodes, String regionCode) {
        List<String> open = Arrays.asList(regionCodes.split(","));
        if (CollectionUtils.isEmpty(open)) {
            return true;
        }
        if (regionCode != null && regionCode.endsWith(ILLEGAL_REGION_CODE_SUFFIX)) {
            for (String openRegin : open) {
                if (!AdxUtils.getCodeForProvince(openRegin).equals(regionCode)) continue;
                return true;
            }
        }
        return open.contains(AdxUtils.getCodeForProvince(regionCode)) || open.contains(AdxUtils.getCodeForCity(regionCode)) || open.contains(regionCode);
    }

    private static String getCodeForProvince(String regionCode) {
        return StringUtils.rightPad((String)StringUtils.left((String)regionCode, (int)2), (int)6, (String)"0");
    }

    private static String getCodeForCity(String regionCode) {
        return StringUtils.rightPad((String)StringUtils.left((String)regionCode, (int)4), (int)6, (String)"0");
    }

    public static AdxErrEnum errCodeVersionControl(BidRequest bidRequest, AdxErrEnum errEnum) {
        if (Objects.nonNull(errEnum) && errEnum == AdxErrEnum.APP_INFO_ERR) {
            return AdxErrEnum.APP_INFO_ERR;
        }
        if (Objects.isNull(bidRequest)) {
            return null;
        }
        if (StringHelper.isNewVersion((String)"3.7.0", (String)bidRequest.getSdk_ver())) {
            return errEnum;
        }
        return null;
    }
}

